/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.DynamicFieldNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIndexFieldsRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DescribeIndexFieldsRequest> {
    private final String domainName;
    private final List<String> fieldNames;
    private final Boolean deployed;

    private DescribeIndexFieldsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.fieldNames = builder.fieldNames;
        this.deployed = builder.deployed;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsRequest)) {
            return false;
        }
        DescribeIndexFieldsRequest other = (DescribeIndexFieldsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.fieldNames(), other.fieldNames()) && Objects.equals(this.deployed(), other.deployed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.fieldNames() != null) {
            sb.append("FieldNames: ").append(this.fieldNames()).append(",");
        }
        if (this.deployed() != null) {
            sb.append("Deployed: ").append(this.deployed()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "FieldNames": {
                return Optional.of(clazz.cast(this.fieldNames()));
            }
            case "Deployed": {
                return Optional.of(clazz.cast(this.deployed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> fieldNames;
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsRequest model) {
            this.domainName(model.domainName);
            this.fieldNames(model.fieldNames);
            this.deployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getFieldNames() {
            return this.fieldNames;
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String ... fieldNames) {
            this.fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeIndexFieldsRequest build() {
            return new DescribeIndexFieldsRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, DescribeIndexFieldsRequest> {
        public Builder domainName(String var1);

        public Builder fieldNames(Collection<String> var1);

        public Builder fieldNames(String ... var1);

        public Builder deployed(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

