/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeStatus;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeStatusListCopier;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAnalysisSchemesResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeAnalysisSchemesResponse> {
    private final List<AnalysisSchemeStatus> analysisSchemes;

    private DescribeAnalysisSchemesResponse(BuilderImpl builder) {
        super(builder);
        this.analysisSchemes = builder.analysisSchemes;
    }

    public List<AnalysisSchemeStatus> analysisSchemes() {
        return this.analysisSchemes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisSchemesResponse)) {
            return false;
        }
        DescribeAnalysisSchemesResponse other = (DescribeAnalysisSchemesResponse)((Object)obj);
        return Objects.equals(this.analysisSchemes(), other.analysisSchemes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.analysisSchemes() != null) {
            sb.append("AnalysisSchemes: ").append(this.analysisSchemes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSchemes": {
                return Optional.of(clazz.cast(this.analysisSchemes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<AnalysisSchemeStatus> analysisSchemes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisSchemesResponse model) {
            this.analysisSchemes(model.analysisSchemes);
        }

        public final Collection<AnalysisSchemeStatus.Builder> getAnalysisSchemes() {
            return this.analysisSchemes != null ? (Collection)this.analysisSchemes.stream().map(AnalysisSchemeStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder analysisSchemes(Collection<AnalysisSchemeStatus> analysisSchemes) {
            this.analysisSchemes = AnalysisSchemeStatusListCopier.copy(analysisSchemes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSchemes(AnalysisSchemeStatus ... analysisSchemes) {
            this.analysisSchemes(Arrays.asList(analysisSchemes));
            return this;
        }

        public final void setAnalysisSchemes(Collection<AnalysisSchemeStatus.BuilderImpl> analysisSchemes) {
            this.analysisSchemes = AnalysisSchemeStatusListCopier.copyFromBuilder(analysisSchemes);
        }

        @Override
        public DescribeAnalysisSchemesResponse build() {
            return new DescribeAnalysisSchemesResponse(this);
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    CopyableBuilder<Builder, DescribeAnalysisSchemesResponse> {
        public Builder analysisSchemes(Collection<AnalysisSchemeStatus> var1);

        public Builder analysisSchemes(AnalysisSchemeStatus ... var1);
    }
}

