/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo;
import software.amazon.awssdk.services.cloudsearchdomain.model.FacetsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldStats;
import software.amazon.awssdk.services.cloudsearchdomain.model.Hits;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchStatus;
import software.amazon.awssdk.services.cloudsearchdomain.model.StatsCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SearchResponse> {
    private final SearchStatus status;
    private final Hits hits;
    private final Map<String, BucketInfo> facets;
    private final Map<String, FieldStats> stats;

    private SearchResponse(BuilderImpl builder) {
        this.status = builder.status;
        this.hits = builder.hits;
        this.facets = builder.facets;
        this.stats = builder.stats;
    }

    public SearchStatus status() {
        return this.status;
    }

    public Hits hits() {
        return this.hits;
    }

    public Map<String, BucketInfo> facets() {
        return this.facets;
    }

    public Map<String, FieldStats> stats() {
        return this.stats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.hits() == null ? 0 : this.hits().hashCode());
        hashCode = 31 * hashCode + (this.facets() == null ? 0 : this.facets().hashCode());
        hashCode = 31 * hashCode + (this.stats() == null ? 0 : this.stats().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResponse)) {
            return false;
        }
        SearchResponse other = (SearchResponse)((Object)obj);
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.hits() == null ^ this.hits() == null) {
            return false;
        }
        if (other.hits() != null && !other.hits().equals(this.hits())) {
            return false;
        }
        if (other.facets() == null ^ this.facets() == null) {
            return false;
        }
        if (other.facets() != null && !other.facets().equals(this.facets())) {
            return false;
        }
        if (other.stats() == null ^ this.stats() == null) {
            return false;
        }
        return other.stats() == null || other.stats().equals(this.stats());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.hits() != null) {
            sb.append("Hits: ").append(this.hits()).append(",");
        }
        if (this.facets() != null) {
            sb.append("Facets: ").append(this.facets()).append(",");
        }
        if (this.stats() != null) {
            sb.append("Stats: ").append(this.stats()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "hits": {
                return Optional.of(clazz.cast(this.hits()));
            }
            case "facets": {
                return Optional.of(clazz.cast(this.facets()));
            }
            case "stats": {
                return Optional.of(clazz.cast(this.stats()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private SearchStatus status;
        private Hits hits;
        private Map<String, BucketInfo> facets;
        private Map<String, FieldStats> stats;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResponse model) {
            this.status(model.status);
            this.hits(model.hits);
            this.facets(model.facets);
            this.stats(model.stats);
        }

        public final SearchStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(SearchStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(SearchStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Hits.Builder getHits() {
            return this.hits != null ? this.hits.toBuilder() : null;
        }

        @Override
        public final Builder hits(Hits hits) {
            this.hits = hits;
            return this;
        }

        public final void setHits(Hits.BuilderImpl hits) {
            this.hits = hits != null ? hits.build() : null;
        }

        public final Map<String, BucketInfo.Builder> getFacets() {
            return this.facets != null ? CollectionUtils.mapValues(this.facets, BucketInfo::toBuilder) : null;
        }

        @Override
        public final Builder facets(Map<String, BucketInfo> facets) {
            this.facets = FacetsCopier.copy(facets);
            return this;
        }

        public final void setFacets(Map<String, BucketInfo.BuilderImpl> facets) {
            this.facets = FacetsCopier.copyFromBuilder(facets);
        }

        public final Map<String, FieldStats.Builder> getStats() {
            return this.stats != null ? CollectionUtils.mapValues(this.stats, FieldStats::toBuilder) : null;
        }

        @Override
        public final Builder stats(Map<String, FieldStats> stats) {
            this.stats = StatsCopier.copy(stats);
            return this;
        }

        public final void setStats(Map<String, FieldStats.BuilderImpl> stats) {
            this.stats = StatsCopier.copyFromBuilder(stats);
        }

        public SearchResponse build() {
            return new SearchResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchResponse> {
        public Builder status(SearchStatus var1);

        public Builder hits(Hits var1);

        public Builder facets(Map<String, BucketInfo> var1);

        public Builder stats(Map<String, FieldStats> var1);
    }
}

