/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DocumentSuggesterOptions;
import software.amazon.awssdk.services.cloudsearch.model.Suggester;

public class DefineSuggesterRequestMarshaller
implements Marshaller<Request<DefineSuggesterRequest>, DefineSuggesterRequest> {
    public Request<DefineSuggesterRequest> marshall(DefineSuggesterRequest defineSuggesterRequest) {
        Suggester suggester;
        if (defineSuggesterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineSuggesterRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineSuggester");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineSuggesterRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineSuggesterRequest.domainName()));
        }
        if ((suggester = defineSuggesterRequest.suggester()) != null) {
            DocumentSuggesterOptions documentSuggesterOptions;
            if (suggester.suggesterName() != null) {
                request.addParameter("Suggester.SuggesterName", StringUtils.fromString((String)suggester.suggesterName()));
            }
            if ((documentSuggesterOptions = suggester.documentSuggesterOptions()) != null) {
                if (documentSuggesterOptions.sourceField() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SourceField", StringUtils.fromString((String)documentSuggesterOptions.sourceField()));
                }
                if (documentSuggesterOptions.fuzzyMatchingString() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.FuzzyMatching", StringUtils.fromString((String)documentSuggesterOptions.fuzzyMatchingString()));
                }
                if (documentSuggesterOptions.sortExpression() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SortExpression", StringUtils.fromString((String)documentSuggesterOptions.sortExpression()));
                }
            }
        }
        return request;
    }
}

