/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.Expression;

public class DefineExpressionRequestMarshaller
implements Marshaller<Request<DefineExpressionRequest>, DefineExpressionRequest> {
    public Request<DefineExpressionRequest> marshall(DefineExpressionRequest defineExpressionRequest) {
        Expression expression;
        if (defineExpressionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineExpressionRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineExpression");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineExpressionRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineExpressionRequest.domainName()));
        }
        if ((expression = defineExpressionRequest.expression()) != null) {
            if (expression.expressionName() != null) {
                request.addParameter("Expression.ExpressionName", StringUtils.fromString((String)expression.expressionName()));
            }
            if (expression.expressionValue() != null) {
                request.addParameter("Expression.ExpressionValue", StringUtils.fromString((String)expression.expressionValue()));
            }
        }
        return request;
    }
}

