/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParameters;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateScalingParametersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateScalingParametersRequest> {
    private final String domainName;
    private final ScalingParameters scalingParameters;

    private UpdateScalingParametersRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.scalingParameters = builder.scalingParameters;
    }

    public String domainName() {
        return this.domainName;
    }

    public ScalingParameters scalingParameters() {
        return this.scalingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.scalingParameters() == null ? 0 : this.scalingParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingParametersRequest)) {
            return false;
        }
        UpdateScalingParametersRequest other = (UpdateScalingParametersRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.scalingParameters() == null ^ this.scalingParameters() == null) {
            return false;
        }
        return other.scalingParameters() == null || other.scalingParameters().equals(this.scalingParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.scalingParameters() != null) {
            sb.append("ScalingParameters: ").append(this.scalingParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "ScalingParameters": {
                return Optional.of(clazz.cast(this.scalingParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private ScalingParameters scalingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScalingParametersRequest model) {
            this.domainName(model.domainName);
            this.scalingParameters(model.scalingParameters);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ScalingParameters.Builder getScalingParameters() {
            return this.scalingParameters != null ? this.scalingParameters.toBuilder() : null;
        }

        @Override
        public final Builder scalingParameters(ScalingParameters scalingParameters) {
            this.scalingParameters = scalingParameters;
            return this;
        }

        public final void setScalingParameters(ScalingParameters.BuilderImpl scalingParameters) {
            this.scalingParameters = scalingParameters != null ? scalingParameters.build() : null;
        }

        public UpdateScalingParametersRequest build() {
            return new UpdateScalingParametersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateScalingParametersRequest> {
        public Builder domainName(String var1);

        public Builder scalingParameters(ScalingParameters var1);
    }
}

