/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus;
import software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIndexFieldsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeIndexFieldsResponse> {
    private final List<IndexFieldStatus> indexFields;

    private DescribeIndexFieldsResponse(BuilderImpl builder) {
        this.indexFields = builder.indexFields;
    }

    public List<IndexFieldStatus> indexFields() {
        return this.indexFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.indexFields() == null ? 0 : this.indexFields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsResponse)) {
            return false;
        }
        DescribeIndexFieldsResponse other = (DescribeIndexFieldsResponse)((Object)obj);
        if (other.indexFields() == null ^ this.indexFields() == null) {
            return false;
        }
        return other.indexFields() == null || other.indexFields().equals(this.indexFields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.indexFields() != null) {
            sb.append("IndexFields: ").append(this.indexFields()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexFields": {
                return Optional.of(clazz.cast(this.indexFields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<IndexFieldStatus> indexFields;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsResponse model) {
            this.indexFields(model.indexFields);
        }

        public final Collection<IndexFieldStatus.Builder> getIndexFields() {
            return this.indexFields != null ? (Collection)this.indexFields.stream().map(IndexFieldStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder indexFields(Collection<IndexFieldStatus> indexFields) {
            this.indexFields = IndexFieldStatusListCopier.copy(indexFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexFields(IndexFieldStatus ... indexFields) {
            this.indexFields(Arrays.asList(indexFields));
            return this;
        }

        public final void setIndexFields(Collection<IndexFieldStatus.BuilderImpl> indexFields) {
            this.indexFields = IndexFieldStatusListCopier.copyFromBuilder(indexFields);
        }

        public DescribeIndexFieldsResponse build() {
            return new DescribeIndexFieldsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeIndexFieldsResponse> {
        public Builder indexFields(Collection<IndexFieldStatus> var1);

        public Builder indexFields(IndexFieldStatus ... var1);
    }
}

