/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteSuggesterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteSuggesterRequest> {
    private final String domainName;
    private final String suggesterName;

    private DeleteSuggesterRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.suggesterName = builder.suggesterName;
    }

    public String domainName() {
        return this.domainName;
    }

    public String suggesterName() {
        return this.suggesterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.suggesterName() == null ? 0 : this.suggesterName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSuggesterRequest)) {
            return false;
        }
        DeleteSuggesterRequest other = (DeleteSuggesterRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.suggesterName() == null ^ this.suggesterName() == null) {
            return false;
        }
        return other.suggesterName() == null || other.suggesterName().equals(this.suggesterName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.suggesterName() != null) {
            sb.append("SuggesterName: ").append(this.suggesterName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "SuggesterName": {
                return Optional.of(clazz.cast(this.suggesterName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String suggesterName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSuggesterRequest model) {
            this.domainName(model.domainName);
            this.suggesterName(model.suggesterName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getSuggesterName() {
            return this.suggesterName;
        }

        @Override
        public final Builder suggesterName(String suggesterName) {
            this.suggesterName = suggesterName;
            return this;
        }

        public final void setSuggesterName(String suggesterName) {
            this.suggesterName = suggesterName;
        }

        public DeleteSuggesterRequest build() {
            return new DeleteSuggesterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteSuggesterRequest> {
        public Builder domainName(String var1);

        public Builder suggesterName(String var1);
    }
}

