/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisScheme;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefineAnalysisSchemeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DefineAnalysisSchemeRequest> {
    private final String domainName;
    private final AnalysisScheme analysisScheme;

    private DefineAnalysisSchemeRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.analysisScheme = builder.analysisScheme;
    }

    public String domainName() {
        return this.domainName;
    }

    public AnalysisScheme analysisScheme() {
        return this.analysisScheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.analysisScheme() == null ? 0 : this.analysisScheme().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineAnalysisSchemeRequest)) {
            return false;
        }
        DefineAnalysisSchemeRequest other = (DefineAnalysisSchemeRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.analysisScheme() == null ^ this.analysisScheme() == null) {
            return false;
        }
        return other.analysisScheme() == null || other.analysisScheme().equals(this.analysisScheme());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.analysisScheme() != null) {
            sb.append("AnalysisScheme: ").append(this.analysisScheme()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "AnalysisScheme": {
                return Optional.of(clazz.cast(this.analysisScheme()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private AnalysisScheme analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineAnalysisSchemeRequest model) {
            this.domainName(model.domainName);
            this.analysisScheme(model.analysisScheme);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final AnalysisScheme.Builder getAnalysisScheme() {
            return this.analysisScheme != null ? this.analysisScheme.toBuilder() : null;
        }

        @Override
        public final Builder analysisScheme(AnalysisScheme analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        public final void setAnalysisScheme(AnalysisScheme.BuilderImpl analysisScheme) {
            this.analysisScheme = analysisScheme != null ? analysisScheme.build() : null;
        }

        public DefineAnalysisSchemeRequest build() {
            return new DefineAnalysisSchemeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefineAnalysisSchemeRequest> {
        public Builder domainName(String var1);

        public Builder analysisScheme(AnalysisScheme var1);
    }
}

