/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum QueryParser {
    Simple("simple"),
    Structured("structured"),
    Lucene("lucene"),
    Dismax("dismax");

    private final String value;

    private QueryParser(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static QueryParser fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(QueryParser.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

