/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum IndexFieldType {
    Int("int"),
    Double("double"),
    Literal("literal"),
    Text("text"),
    Date("date"),
    Latlon("latlon"),
    IntArray("int-array"),
    DoubleArray("double-array"),
    LiteralArray("literal-array"),
    TextArray("text-array"),
    DateArray("date-array");

    private final String value;

    private IndexFieldType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static IndexFieldType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(IndexFieldType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

