/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CloudHsmObjectState {
    READY("READY"),
    UPDATING("UPDATING"),
    DEGRADED("DEGRADED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudHsmObjectState> VALUE_MAP;
    private final String value;

    private CloudHsmObjectState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloudHsmObjectState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloudHsmObjectState> knownValues() {
        EnumSet<CloudHsmObjectState> knownValues = EnumSet.allOf(CloudHsmObjectState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CloudHsmObjectState.class, CloudHsmObjectState::toString);
    }
}

