/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.ClientListCopier;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLunaClientsResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, ListLunaClientsResponse> {
    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientList").getter(ListLunaClientsResponse.getter(ListLunaClientsResponse::clientList)).setter(ListLunaClientsResponse.setter(Builder::clientList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLunaClientsResponse.getter(ListLunaClientsResponse::nextToken)).setter(ListLunaClientsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> clientList;
    private final String nextToken;

    private ListLunaClientsResponse(BuilderImpl builder) {
        super(builder);
        this.clientList = builder.clientList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasClientList() {
        return this.clientList != null && !(this.clientList instanceof SdkAutoConstructList);
    }

    public List<String> clientList() {
        return this.clientList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLunaClientsResponse)) {
            return false;
        }
        ListLunaClientsResponse other = (ListLunaClientsResponse)((Object)obj);
        return Objects.equals(this.clientList(), other.clientList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLunaClientsResponse").add("ClientList", this.clientList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientList": {
                return Optional.ofNullable(clazz.cast(this.clientList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLunaClientsResponse, T> g) {
        return obj -> g.apply((ListLunaClientsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLunaClientsResponse model) {
            super(model);
            this.clientList(model.clientList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getClientList() {
            return this.clientList;
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String ... clientList) {
            this.clientList(Arrays.asList(clientList));
            return this;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = ClientListCopier.copy(clientList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLunaClientsResponse build() {
            return new ListLunaClientsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLunaClientsResponse> {
        public Builder clientList(Collection<String> var1);

        public Builder clientList(String ... var1);

        public Builder nextToken(String var1);
    }
}

