/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HsmStatus {
    PENDING("PENDING"),
    RUNNING("RUNNING"),
    UPDATING("UPDATING"),
    SUSPENDED("SUSPENDED"),
    TERMINATING("TERMINATING"),
    TERMINATED("TERMINATED"),
    DEGRADED("DEGRADED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HsmStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HsmStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HsmStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HsmStatus> knownValues() {
        return Stream.of(HsmStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

