/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.CloudFrontKeyValueStoreClientBuilder;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.CloudFrontKeyValueStoreServiceClientConfiguration;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.DefaultCloudFrontKeyValueStoreClientBuilder;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.CloudFrontKeyValueStoreException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ConflictException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.InternalServerException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ValidationException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable;

@SdkPublicApi
@ThreadSafe
public interface CloudFrontKeyValueStoreClient
extends AwsClient {
    public static final String SERVICE_NAME = "cloudfront-keyvaluestore";
    public static final String SERVICE_METADATA_ID = "cloudfront-keyvaluestore";

    default public DeleteKeyResponse deleteKey(DeleteKeyRequest deleteKeyRequest) throws ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    default public DeleteKeyResponse deleteKey(Consumer<DeleteKeyRequest.Builder> deleteKeyRequest) throws ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return this.deleteKey((DeleteKeyRequest)((Object)((DeleteKeyRequest.Builder)DeleteKeyRequest.builder().applyMutation(deleteKeyRequest)).build()));
    }

    default public DescribeKeyValueStoreResponse describeKeyValueStore(DescribeKeyValueStoreRequest describeKeyValueStoreRequest) throws ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    default public DescribeKeyValueStoreResponse describeKeyValueStore(Consumer<DescribeKeyValueStoreRequest.Builder> describeKeyValueStoreRequest) throws ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return this.describeKeyValueStore((DescribeKeyValueStoreRequest)((Object)((DescribeKeyValueStoreRequest.Builder)DescribeKeyValueStoreRequest.builder().applyMutation(describeKeyValueStoreRequest)).build()));
    }

    default public GetKeyResponse getKey(GetKeyRequest getKeyRequest) throws ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    default public GetKeyResponse getKey(Consumer<GetKeyRequest.Builder> getKeyRequest) throws ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return this.getKey((GetKeyRequest)((Object)((GetKeyRequest.Builder)GetKeyRequest.builder().applyMutation(getKeyRequest)).build()));
    }

    default public ListKeysResponse listKeys(ListKeysRequest listKeysRequest) throws ConflictException, ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    default public ListKeysResponse listKeys(Consumer<ListKeysRequest.Builder> listKeysRequest) throws ConflictException, ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return this.listKeys((ListKeysRequest)((Object)((ListKeysRequest.Builder)ListKeysRequest.builder().applyMutation(listKeysRequest)).build()));
    }

    default public ListKeysIterable listKeysPaginator(ListKeysRequest listKeysRequest) throws ConflictException, ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return new ListKeysIterable(this, listKeysRequest);
    }

    default public ListKeysIterable listKeysPaginator(Consumer<ListKeysRequest.Builder> listKeysRequest) throws ConflictException, ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return this.listKeysPaginator((ListKeysRequest)((Object)((ListKeysRequest.Builder)ListKeysRequest.builder().applyMutation(listKeysRequest)).build()));
    }

    default public PutKeyResponse putKey(PutKeyRequest putKeyRequest) throws ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    default public PutKeyResponse putKey(Consumer<PutKeyRequest.Builder> putKeyRequest) throws ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return this.putKey((PutKeyRequest)((Object)((PutKeyRequest.Builder)PutKeyRequest.builder().applyMutation(putKeyRequest)).build()));
    }

    default public UpdateKeysResponse updateKeys(UpdateKeysRequest updateKeysRequest) throws ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    default public UpdateKeysResponse updateKeys(Consumer<UpdateKeysRequest.Builder> updateKeysRequest) throws ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return this.updateKeys((UpdateKeysRequest)((Object)((UpdateKeysRequest.Builder)UpdateKeysRequest.builder().applyMutation(updateKeysRequest)).build()));
    }

    public static CloudFrontKeyValueStoreClient create() {
        return (CloudFrontKeyValueStoreClient)CloudFrontKeyValueStoreClient.builder().build();
    }

    public static CloudFrontKeyValueStoreClientBuilder builder() {
        return new DefaultCloudFrontKeyValueStoreClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"cloudfront-keyvaluestore");
    }

    default public CloudFrontKeyValueStoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

