/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeletePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionProfilesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;

@SdkInternalApi
final class DefaultCloudFrontClient
implements CloudFrontClient {
    private final SyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFrontClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "cloudfront";
    }

    @Override
    public CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException, TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudFrontOriginAccessIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new CreateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest) throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDistributionRequest).withMarshaller((Marshaller)new CreateDistributionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDistributionWithTagsResponse createDistributionWithTags(CreateDistributionWithTagsRequest createDistributionWithTagsRequest) throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, InvalidTaggingException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDistributionWithTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistributionWithTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDistributionWithTagsRequest).withMarshaller((Marshaller)new CreateDistributionWithTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest) throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException, FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException, TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException, QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new CreateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest) throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException, FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException, TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new CreateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateInvalidationResponse createInvalidation(CreateInvalidationRequest createInvalidationRequest) throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException, BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateInvalidationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInvalidation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createInvalidationRequest).withMarshaller((Marshaller)new CreateInvalidationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePublicKeyResponse createPublicKey(CreatePublicKeyRequest createPublicKeyRequest) throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreatePublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPublicKeyRequest).withMarshaller((Marshaller)new CreatePublicKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStreamingDistributionResponse createStreamingDistribution(CreateStreamingDistributionRequest createStreamingDistributionRequest) throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStreamingDistributionRequest).withMarshaller((Marshaller)new CreateStreamingDistributionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException, InvalidTaggingException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateStreamingDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateStreamingDistributionWithTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistributionWithTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStreamingDistributionWithTagsRequest).withMarshaller((Marshaller)new CreateStreamingDistributionWithTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCloudFrontOriginAccessIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new DeleteCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDistributionRequest).withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException, FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new DeleteFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException, FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new DeleteFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePublicKeyResponse deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) throws AccessDeniedException, PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeletePublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePublicKeyRequest).withMarshaller((Marshaller)new DeletePublicKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteStreamingDistributionResponse deleteStreamingDistribution(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AccessDeniedException, StreamingDistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchStreamingDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStreamingDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStreamingDistributionRequest).withMarshaller((Marshaller)new DeleteStreamingDistributionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCloudFrontOriginAccessIdentityConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetCloudFrontOriginAccessIdentityConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentityConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCloudFrontOriginAccessIdentityConfigRequest).withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetDistributionResponse getDistribution(GetDistributionRequest getDistributionRequest) throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDistributionRequest).withMarshaller((Marshaller)new GetDistributionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetDistributionConfigResponse getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest) throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetDistributionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDistributionConfigRequest).withMarshaller((Marshaller)new GetDistributionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFieldLevelEncryptionResponse getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFieldLevelEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetFieldLevelEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFieldLevelEncryptionRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest) throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFieldLevelEncryptionProfileConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetFieldLevelEncryptionProfileConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfileConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFieldLevelEncryptionProfileConfigRequest).withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetInvalidationResponse getInvalidation(GetInvalidationRequest getInvalidationRequest) throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetInvalidationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInvalidation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInvalidationRequest).withMarshaller((Marshaller)new GetInvalidationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetPublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPublicKeyRequest).withMarshaller((Marshaller)new GetPublicKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPublicKeyConfigResponse getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest) throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetPublicKeyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetPublicKeyConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKeyConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPublicKeyConfigRequest).withMarshaller((Marshaller)new GetPublicKeyConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetStreamingDistributionResponse getStreamingDistribution(GetStreamingDistributionRequest getStreamingDistributionRequest) throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getStreamingDistributionRequest).withMarshaller((Marshaller)new GetStreamingDistributionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetStreamingDistributionConfigResponse getStreamingDistributionConfig(GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetStreamingDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetStreamingDistributionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistributionConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getStreamingDistributionConfigRequest).withMarshaller((Marshaller)new GetStreamingDistributionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListCloudFrontOriginAccessIdentitiesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListCloudFrontOriginAccessIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCloudFrontOriginAccessIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCloudFrontOriginAccessIdentitiesRequest).withMarshaller((Marshaller)new ListCloudFrontOriginAccessIdentitiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDistributionsResponse listDistributions(ListDistributionsRequest listDistributionsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListDistributionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDistributionsRequest).withMarshaller((Marshaller)new ListDistributionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) throws InvalidArgumentException, InvalidWebAclIdException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListDistributionsByWebAclIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListDistributionsByWebAclIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByWebACLId").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDistributionsByWebAclIdRequest).withMarshaller((Marshaller)new ListDistributionsByWebAclIdRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListFieldLevelEncryptionConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListFieldLevelEncryptionConfigsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionConfigs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFieldLevelEncryptionConfigsRequest).withMarshaller((Marshaller)new ListFieldLevelEncryptionConfigsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListFieldLevelEncryptionProfilesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListFieldLevelEncryptionProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFieldLevelEncryptionProfilesRequest).withMarshaller((Marshaller)new ListFieldLevelEncryptionProfilesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListInvalidationsResponse listInvalidations(ListInvalidationsRequest listInvalidationsRequest) throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListInvalidationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListInvalidationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvalidations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInvalidationsRequest).withMarshaller((Marshaller)new ListInvalidationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListPublicKeysResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListPublicKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublicKeys").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPublicKeysRequest).withMarshaller((Marshaller)new ListPublicKeysRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStreamingDistributionsResponse listStreamingDistributions(ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListStreamingDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListStreamingDistributionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamingDistributions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStreamingDistributionsRequest).withMarshaller((Marshaller)new ListStreamingDistributionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException, NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateCloudFrontOriginAccessIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCloudFrontOriginAccessIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCloudFrontOriginAccessIdentityRequest).withMarshaller((Marshaller)new UpdateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest) throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException, InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException, InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException, TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDistributionRequest).withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException, TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException, QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateFieldLevelEncryptionConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFieldLevelEncryptionConfigRequest).withMarshaller((Marshaller)new UpdateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) throws AccessDeniedException, FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException, FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException, TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateFieldLevelEncryptionProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFieldLevelEncryptionProfileRequest).withMarshaller((Marshaller)new UpdateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdatePublicKeyResponse updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) throws AccessDeniedException, CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException, InvalidIfMatchVersionException, IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdatePublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePublicKeyRequest).withMarshaller((Marshaller)new UpdatePublicKeyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateStreamingDistributionResponse updateStreamingDistribution(UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException, NoSuchStreamingDistributionException, PreconditionFailedException, TooManyStreamingDistributionCnamEsException, InvalidArgumentException, InvalidOriginAccessIdentityException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateStreamingDistributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamingDistribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStreamingDistributionRequest).withMarshaller((Marshaller)new UpdateStreamingDistributionRequestMarshaller(this.protocolFactory)));
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionAlreadyExists").exceptionBuilderSupplier(StreamingDistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrustedSignerDoesNotExist").exceptionBuilderSupplier(TrustedSignerDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchInvalidation").exceptionBuilderSupplier(NoSuchInvalidationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionConfig").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInForwardedValues").exceptionBuilderSupplier(TooManyHeadersInForwardedValuesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginReadTimeout").exceptionBuilderSupplier(InvalidOriginReadTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMinimumProtocolVersion").exceptionBuilderSupplier(InvalidMinimumProtocolVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyInvalidationsInProgress").exceptionBuilderSupplier(TooManyInvalidationsInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionConfigs").exceptionBuilderSupplier(TooManyFieldLevelEncryptionConfigsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPublicKeys").exceptionBuilderSupplier(TooManyPublicKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidErrorCode").exceptionBuilderSupplier(InvalidErrorCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCacheBehaviors").exceptionBuilderSupplier(TooManyCacheBehaviorsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityInUse").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionProfileAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionFieldPatterns").exceptionBuilderSupplier(TooManyFieldLevelEncryptionFieldPatternsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingBody").exceptionBuilderSupplier(MissingBodyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOrigins").exceptionBuilderSupplier(TooManyOriginsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior").exceptionBuilderSupplier(IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequiredProtocol").exceptionBuilderSupplier(InvalidRequiredProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchOrigin").exceptionBuilderSupplier(NoSuchOriginException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrustedSigners").exceptionBuilderSupplier(TooManyTrustedSignersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchTooLarge").exceptionBuilderSupplier(BatchTooLargeException::builder).httpStatusCode(Integer.valueOf(413)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResponseCode").exceptionBuilderSupplier(InvalidResponseCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginKeepaliveTimeout").exceptionBuilderSupplier(InvalidOriginKeepaliveTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributionCNAMEs").exceptionBuilderSupplier(TooManyStreamingDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributions").exceptionBuilderSupplier(TooManyStreamingDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyInUse").exceptionBuilderSupplier(PublicKeyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionNotDisabled").exceptionBuilderSupplier(StreamingDistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionCNAMEs").exceptionBuilderSupplier(TooManyDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailed").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringParameters").exceptionBuilderSupplier(TooManyQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionEncryptionEntities").exceptionBuilderSupplier(TooManyFieldLevelEncryptionEncryptionEntitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigInUse").exceptionBuilderSupplier(FieldLevelEncryptionConfigInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionAlreadyExists").exceptionBuilderSupplier(DistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityAlreadyExists").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidProtocolSettings").exceptionBuilderSupplier(InvalidProtocolSettingsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginCustomHeaders").exceptionBuilderSupplier(TooManyOriginCustomHeadersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLocationCode").exceptionBuilderSupplier(InvalidLocationCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidForwardCookies").exceptionBuilderSupplier(InvalidForwardCookiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileSizeExceeded").exceptionBuilderSupplier(FieldLevelEncryptionProfileSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCertificates").exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryArgProfileEmpty").exceptionBuilderSupplier(QueryArgProfileEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginAccessIdentity").exceptionBuilderSupplier(InvalidOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidQueryStringParameters").exceptionBuilderSupplier(InvalidQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalUpdate").exceptionBuilderSupplier(IllegalUpdateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookieNamesInWhiteList").exceptionBuilderSupplier(TooManyCookieNamesInWhiteListException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDistribution").exceptionBuilderSupplier(NoSuchDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CNAMEAlreadyExists").exceptionBuilderSupplier(CnameAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionProfile").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionProfileException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchResource").exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTTLOrder").exceptionBuilderSupplier(InvalidTtlOrderException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InconsistentQuantities").exceptionBuilderSupplier(InconsistentQuantitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionAssociation").exceptionBuilderSupplier(InvalidLambdaFunctionAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLambdaFunctionAssociations").exceptionBuilderSupplier(TooManyLambdaFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidViewerCertificate").exceptionBuilderSupplier(InvalidViewerCertificateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionNotDisabled").exceptionBuilderSupplier(DistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginGroupsPerDistribution").exceptionBuilderSupplier(TooManyOriginGroupsPerDistributionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDefaultRootObject").exceptionBuilderSupplier(InvalidDefaultRootObjectException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDenied").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgument").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchStreamingDistribution").exceptionBuilderSupplier(NoSuchStreamingDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCloudFrontOriginAccessIdentities").exceptionBuilderSupplier(TooManyCloudFrontOriginAccessIdentitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicKey").exceptionBuilderSupplier(NoSuchPublicKeyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionContentTypeProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionContentTypeProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRelativePath").exceptionBuilderSupplier(InvalidRelativePathException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebACLId").exceptionBuilderSupplier(InvalidWebAclIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig").exceptionBuilderSupplier(TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithLambdaAssociations").exceptionBuilderSupplier(TooManyDistributionsWithLambdaAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHeadersForS3Origin").exceptionBuilderSupplier(InvalidHeadersForS3OriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributions").exceptionBuilderSupplier(TooManyDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotChangeImmutablePublicKeyFields").exceptionBuilderSupplier(CannotChangeImmutablePublicKeyFieldsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionQueryArgProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionQueryArgProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyAlreadyExists").exceptionBuilderSupplier(PublicKeyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileInUse").exceptionBuilderSupplier(FieldLevelEncryptionProfileInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIfMatchVersion").exceptionBuilderSupplier(InvalidIfMatchVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagging").exceptionBuilderSupplier(InvalidTaggingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOrigin").exceptionBuilderSupplier(InvalidOriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCloudFrontOriginAccessIdentity").exceptionBuilderSupplier(NoSuchCloudFrontOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGeoRestrictionParameter").exceptionBuilderSupplier(InvalidGeoRestrictionParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudFrontException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudFrontRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.7.25").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFrontRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

