/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to update a streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStreamingDistributionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateStreamingDistributionRequest.Builder, UpdateStreamingDistributionRequest> {
    private static final SdkField<StreamingDistributionConfig> STREAMING_DISTRIBUTION_CONFIG_FIELD = SdkField
            .<StreamingDistributionConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateStreamingDistributionRequest::streamingDistributionConfig))
            .setter(setter(Builder::streamingDistributionConfig))
            .constructor(StreamingDistributionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionConfig")
                    .unmarshallLocationName("StreamingDistributionConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStreamingDistributionRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateStreamingDistributionRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STREAMING_DISTRIBUTION_CONFIG_FIELD, ID_FIELD, IF_MATCH_FIELD));

    private final StreamingDistributionConfig streamingDistributionConfig;

    private final String id;

    private final String ifMatch;

    private UpdateStreamingDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The streaming distribution's configuration information.
     * </p>
     * 
     * @return The streaming distribution's configuration information.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    /**
     * <p>
     * The streaming distribution's id.
     * </p>
     * 
     * @return The streaming distribution's id.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
     * configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
     *         configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamingDistributionRequest)) {
            return false;
        }
        UpdateStreamingDistributionRequest other = (UpdateStreamingDistributionRequest) obj;
        return Objects.equals(streamingDistributionConfig(), other.streamingDistributionConfig())
                && Objects.equals(id(), other.id()) && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateStreamingDistributionRequest")
                .add("StreamingDistributionConfig", streamingDistributionConfig()).add("Id", id()).add("IfMatch", ifMatch())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistributionConfig":
            return Optional.ofNullable(clazz.cast(streamingDistributionConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamingDistributionRequest, T> g) {
        return obj -> g.apply((UpdateStreamingDistributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateStreamingDistributionRequest> {
        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The streaming distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistributionConfig.Builder} avoiding
         * the need to create one manually via {@link StreamingDistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistributionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingDistributionConfig(StreamingDistributionConfig)}.
         * 
         * @param streamingDistributionConfig
         *        a consumer that will call methods on {@link StreamingDistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionConfig(StreamingDistributionConfig)
         */
        default Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return streamingDistributionConfig(StreamingDistributionConfig.builder().applyMutation(streamingDistributionConfig)
                    .build());
        }

        /**
         * <p>
         * The streaming distribution's id.
         * </p>
         * 
         * @param id
         *        The streaming distribution's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
         * configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the streaming
         *        distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamingDistributionRequest model) {
            super(model);
            streamingDistributionConfig(model.streamingDistributionConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return streamingDistributionConfig != null ? streamingDistributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamingDistributionRequest build() {
            return new UpdateStreamingDistributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
