/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new origin access identity (OAI). An origin access identity is a special CloudFront user that
 * you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content. For more
 * information, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">
 * Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon CloudFront Developer
 * Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudFrontOriginAccessIdentityRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateCloudFrontOriginAccessIdentityRequest.Builder, CreateCloudFrontOriginAccessIdentityRequest> {
    private static final SdkField<CloudFrontOriginAccessIdentityConfig> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD = SdkField
            .<CloudFrontOriginAccessIdentityConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateCloudFrontOriginAccessIdentityRequest::cloudFrontOriginAccessIdentityConfig))
            .setter(setter(Builder::cloudFrontOriginAccessIdentityConfig))
            .constructor(CloudFrontOriginAccessIdentityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CloudFrontOriginAccessIdentityConfig")
                    .unmarshallLocationName("CloudFrontOriginAccessIdentityConfig").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD));

    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private CreateCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
    }

    /**
     * <p>
     * The current configuration information for the identity.
     * </p>
     * 
     * @return The current configuration information for the identity.
     */
    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return cloudFrontOriginAccessIdentityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontOriginAccessIdentityConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        CreateCloudFrontOriginAccessIdentityRequest other = (CreateCloudFrontOriginAccessIdentityRequest) obj;
        return Objects.equals(cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCloudFrontOriginAccessIdentityRequest")
                .add("CloudFrontOriginAccessIdentityConfig", cloudFrontOriginAccessIdentityConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentityConfig":
            return Optional.ofNullable(clazz.cast(cloudFrontOriginAccessIdentityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFrontOriginAccessIdentityRequest, T> g) {
        return obj -> g.apply((CreateCloudFrontOriginAccessIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudFrontOriginAccessIdentityRequest> {
        /**
         * <p>
         * The current configuration information for the identity.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        The current configuration information for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig);

        /**
         * <p>
         * The current configuration information for the identity.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudFrontOriginAccessIdentityConfig.Builder}
         * avoiding the need to create one manually via {@link CloudFrontOriginAccessIdentityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFrontOriginAccessIdentityConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig)}.
         * 
         * @param cloudFrontOriginAccessIdentityConfig
         *        a consumer that will call methods on {@link CloudFrontOriginAccessIdentityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig)
         */
        default Builder cloudFrontOriginAccessIdentityConfig(
                Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.builder()
                    .applyMutation(cloudFrontOriginAccessIdentityConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFrontOriginAccessIdentityRequest model) {
            super(model);
            cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(
                CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig
                    .build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudFrontOriginAccessIdentityRequest build() {
            return new CreateCloudFrontOriginAccessIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
