/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamingDistributionConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetStreamingDistributionConfigResponse> {
    private static final SdkField<StreamingDistributionConfig> STREAMING_DISTRIBUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetStreamingDistributionConfigResponse.getter(GetStreamingDistributionConfigResponse::streamingDistributionConfig)).setter(GetStreamingDistributionConfigResponse.setter(Builder::streamingDistributionConfig)).constructor(StreamingDistributionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionConfig").unmarshallLocationName("StreamingDistributionConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetStreamingDistributionConfigResponse.getter(GetStreamingDistributionConfigResponse::eTag)).setter(GetStreamingDistributionConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_DISTRIBUTION_CONFIG_FIELD, E_TAG_FIELD));
    private final StreamingDistributionConfig streamingDistributionConfig;
    private final String eTag;

    private GetStreamingDistributionConfigResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
        this.eTag = builder.eTag;
    }

    public StreamingDistributionConfig streamingDistributionConfig() {
        return this.streamingDistributionConfig;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamingDistributionConfigResponse)) {
            return false;
        }
        GetStreamingDistributionConfigResponse other = (GetStreamingDistributionConfigResponse)((Object)obj);
        return Objects.equals(this.streamingDistributionConfig(), other.streamingDistributionConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        return ToString.builder((String)"GetStreamingDistributionConfigResponse").add("StreamingDistributionConfig", (Object)this.streamingDistributionConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingDistributionConfig": {
                return Optional.ofNullable(clazz.cast(this.streamingDistributionConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamingDistributionConfigResponse, T> g) {
        return obj -> g.apply((GetStreamingDistributionConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamingDistributionConfigResponse model) {
            super(model);
            this.streamingDistributionConfig(model.streamingDistributionConfig);
            this.eTag(model.eTag);
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return this.streamingDistributionConfig != null ? this.streamingDistributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetStreamingDistributionConfigResponse build() {
            return new GetStreamingDistributionConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamingDistributionConfigResponse> {
        public Builder streamingDistributionConfig(StreamingDistributionConfig var1);

        default public Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return this.streamingDistributionConfig((StreamingDistributionConfig)((StreamingDistributionConfig.Builder)StreamingDistributionConfig.builder().applyMutation(streamingDistributionConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

