/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantResponse;

public class ListInvalidationsForDistributionTenantIterable
implements SdkIterable<ListInvalidationsForDistributionTenantResponse> {
    private final CloudFrontClient client;
    private final ListInvalidationsForDistributionTenantRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvalidationsForDistributionTenantIterable(CloudFrontClient client, ListInvalidationsForDistributionTenantRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvalidationsForDistributionTenantResponseFetcher();
    }

    public Iterator<ListInvalidationsForDistributionTenantResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InvalidationSummary> items() {
        Function<ListInvalidationsForDistributionTenantResponse, Iterator> getIterator = response -> {
            if (response != null && response.invalidationList() != null && response.invalidationList().items() != null) {
                return response.invalidationList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInvalidationsForDistributionTenantResponseFetcher
    implements SyncPageFetcher<ListInvalidationsForDistributionTenantResponse> {
        private ListInvalidationsForDistributionTenantResponseFetcher() {
        }

        public boolean hasNextPage(ListInvalidationsForDistributionTenantResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.invalidationList().nextMarker());
        }

        public ListInvalidationsForDistributionTenantResponse nextPage(ListInvalidationsForDistributionTenantResponse previousPage) {
            if (previousPage == null) {
                return ListInvalidationsForDistributionTenantIterable.this.client.listInvalidationsForDistributionTenant(ListInvalidationsForDistributionTenantIterable.this.firstRequest);
            }
            return ListInvalidationsForDistributionTenantIterable.this.client.listInvalidationsForDistributionTenant((ListInvalidationsForDistributionTenantRequest)((Object)ListInvalidationsForDistributionTenantIterable.this.firstRequest.toBuilder().marker(previousPage.invalidationList().nextMarker()).build()));
        }
    }
}

