/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ConnectionFunctionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionFunctionsResponse;

public class ListConnectionFunctionsIterable
implements SdkIterable<ListConnectionFunctionsResponse> {
    private final CloudFrontClient client;
    private final ListConnectionFunctionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectionFunctionsIterable(CloudFrontClient client, ListConnectionFunctionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectionFunctionsResponseFetcher();
    }

    public Iterator<ListConnectionFunctionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectionFunctionSummary> connectionFunctions() {
        Function<ListConnectionFunctionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionFunctions() != null) {
                return response.connectionFunctions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectionFunctionsResponseFetcher
    implements SyncPageFetcher<ListConnectionFunctionsResponse> {
        private ListConnectionFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListConnectionFunctionsResponse nextPage(ListConnectionFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionFunctionsIterable.this.client.listConnectionFunctions(ListConnectionFunctionsIterable.this.firstRequest);
            }
            return ListConnectionFunctionsIterable.this.client.listConnectionFunctions((ListConnectionFunctionsRequest)((Object)ListConnectionFunctionsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

