/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.FunctionStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestConnectionFunctionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, TestConnectionFunctionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(TestConnectionFunctionRequest.getter(TestConnectionFunctionRequest::id)).setter(TestConnectionFunctionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(TestConnectionFunctionRequest.getter(TestConnectionFunctionRequest::ifMatch)).setter(TestConnectionFunctionRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(TestConnectionFunctionRequest.getter(TestConnectionFunctionRequest::stageAsString)).setter(TestConnectionFunctionRequest.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").unmarshallLocationName("Stage").build()}).build();
    private static final SdkField<SdkBytes> CONNECTION_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ConnectionObject").getter(TestConnectionFunctionRequest.getter(TestConnectionFunctionRequest::connectionObject)).setter(TestConnectionFunctionRequest.setter(Builder::connectionObject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionObject").unmarshallLocationName("ConnectionObject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IF_MATCH_FIELD, STAGE_FIELD, CONNECTION_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestConnectionFunctionRequest.memberNameToFieldInitializer();
    private final String id;
    private final String ifMatch;
    private final String stage;
    private final SdkBytes connectionObject;

    private TestConnectionFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
        this.stage = builder.stage;
        this.connectionObject = builder.connectionObject;
    }

    public final String id() {
        return this.id;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final FunctionStage stage() {
        return FunctionStage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final SdkBytes connectionObject() {
        return this.connectionObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionObject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConnectionFunctionRequest)) {
            return false;
        }
        TestConnectionFunctionRequest other = (TestConnectionFunctionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.connectionObject(), other.connectionObject());
    }

    public final String toString() {
        return ToString.builder((String)"TestConnectionFunctionRequest").add("Id", (Object)this.id()).add("IfMatch", (Object)this.ifMatch()).add("Stage", (Object)this.stageAsString()).add("ConnectionObject", (Object)(this.connectionObject() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "ConnectionObject": {
                return Optional.ofNullable(clazz.cast(this.connectionObject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("ConnectionObject", CONNECTION_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestConnectionFunctionRequest, T> g) {
        return obj -> g.apply((TestConnectionFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String id;
        private String ifMatch;
        private String stage;
        private SdkBytes connectionObject;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConnectionFunctionRequest model) {
            super(model);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
            this.stage(model.stage);
            this.connectionObject(model.connectionObject);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final ByteBuffer getConnectionObject() {
            return this.connectionObject == null ? null : this.connectionObject.asByteBuffer();
        }

        public final void setConnectionObject(ByteBuffer connectionObject) {
            this.connectionObject(connectionObject == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)connectionObject));
        }

        @Override
        public final Builder connectionObject(SdkBytes connectionObject) {
            this.connectionObject = connectionObject;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestConnectionFunctionRequest build() {
            return new TestConnectionFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestConnectionFunctionRequest> {
        public Builder id(String var1);

        public Builder ifMatch(String var1);

        public Builder stage(String var1);

        public Builder stage(FunctionStage var1);

        public Builder connectionObject(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

