/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ConnectionFunctionSummary;
import software.amazon.awssdk.services.cloudfront.model.ConnectionFunctionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectionFunctionsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListConnectionFunctionsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListConnectionFunctionsResponse.getter(ListConnectionFunctionsResponse::nextMarker)).setter(ListConnectionFunctionsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<List<ConnectionFunctionSummary>> CONNECTION_FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionFunctions").getter(ListConnectionFunctionsResponse.getter(ListConnectionFunctionsResponse::connectionFunctions)).setter(ListConnectionFunctionsResponse.setter(Builder::connectionFunctions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctions").unmarshallLocationName("ConnectionFunctions").build(), ListTrait.builder().memberLocationName("ConnectionFunctionSummary").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionFunctionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionSummary").unmarshallLocationName("ConnectionFunctionSummary").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, CONNECTION_FUNCTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectionFunctionsResponse.memberNameToFieldInitializer();
    private final String nextMarker;
    private final List<ConnectionFunctionSummary> connectionFunctions;

    private ListConnectionFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.connectionFunctions = builder.connectionFunctions;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasConnectionFunctions() {
        return this.connectionFunctions != null && !(this.connectionFunctions instanceof SdkAutoConstructList);
    }

    public final List<ConnectionFunctionSummary> connectionFunctions() {
        return this.connectionFunctions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionFunctions() ? this.connectionFunctions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionFunctionsResponse)) {
            return false;
        }
        ListConnectionFunctionsResponse other = (ListConnectionFunctionsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasConnectionFunctions() == other.hasConnectionFunctions() && Objects.equals(this.connectionFunctions(), other.connectionFunctions());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectionFunctionsResponse").add("NextMarker", (Object)this.nextMarker()).add("ConnectionFunctions", this.hasConnectionFunctions() ? this.connectionFunctions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "ConnectionFunctions": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("ConnectionFunctions", CONNECTION_FUNCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionFunctionsResponse, T> g) {
        return obj -> g.apply((ListConnectionFunctionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ConnectionFunctionSummary> connectionFunctions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionFunctionsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.connectionFunctions(model.connectionFunctions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<ConnectionFunctionSummary.Builder> getConnectionFunctions() {
            List<ConnectionFunctionSummary.Builder> result = ConnectionFunctionSummaryListCopier.copyToBuilder(this.connectionFunctions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionFunctions(Collection<ConnectionFunctionSummary.BuilderImpl> connectionFunctions) {
            this.connectionFunctions = ConnectionFunctionSummaryListCopier.copyFromBuilder(connectionFunctions);
        }

        @Override
        public final Builder connectionFunctions(Collection<ConnectionFunctionSummary> connectionFunctions) {
            this.connectionFunctions = ConnectionFunctionSummaryListCopier.copy(connectionFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionFunctions(ConnectionFunctionSummary ... connectionFunctions) {
            this.connectionFunctions(Arrays.asList(connectionFunctions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionFunctions(Consumer<ConnectionFunctionSummary.Builder> ... connectionFunctions) {
            this.connectionFunctions(Stream.of(connectionFunctions).map(c -> (ConnectionFunctionSummary)((ConnectionFunctionSummary.Builder)ConnectionFunctionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConnectionFunctionsResponse build() {
            return new ListConnectionFunctionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectionFunctionsResponse> {
        public Builder nextMarker(String var1);

        public Builder connectionFunctions(Collection<ConnectionFunctionSummary> var1);

        public Builder connectionFunctions(ConnectionFunctionSummary ... var1);

        public Builder connectionFunctions(Consumer<ConnectionFunctionSummary.Builder> ... var1);
    }
}

