/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.KeyValueStore;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeyValueStoreResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, DescribeKeyValueStoreResponse> {
    private static final SdkField<KeyValueStore> KEY_VALUE_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyValueStore").getter(DescribeKeyValueStoreResponse.getter(DescribeKeyValueStoreResponse::keyValueStore)).setter(DescribeKeyValueStoreResponse.setter(Builder::keyValueStore)).constructor(KeyValueStore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValueStore").unmarshallLocationName("KeyValueStore").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(DescribeKeyValueStoreResponse.getter(DescribeKeyValueStoreResponse::eTag)).setter(DescribeKeyValueStoreResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_VALUE_STORE_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeKeyValueStoreResponse.memberNameToFieldInitializer();
    private final KeyValueStore keyValueStore;
    private final String eTag;

    private DescribeKeyValueStoreResponse(BuilderImpl builder) {
        super(builder);
        this.keyValueStore = builder.keyValueStore;
        this.eTag = builder.eTag;
    }

    public final KeyValueStore keyValueStore() {
        return this.keyValueStore;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValueStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyValueStoreResponse)) {
            return false;
        }
        DescribeKeyValueStoreResponse other = (DescribeKeyValueStoreResponse)((Object)obj);
        return Objects.equals(this.keyValueStore(), other.keyValueStore()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeKeyValueStoreResponse").add("KeyValueStore", (Object)this.keyValueStore()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyValueStore": {
                return Optional.ofNullable(clazz.cast(this.keyValueStore()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyValueStore", KEY_VALUE_STORE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyValueStoreResponse, T> g) {
        return obj -> g.apply((DescribeKeyValueStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private KeyValueStore keyValueStore;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyValueStoreResponse model) {
            super(model);
            this.keyValueStore(model.keyValueStore);
            this.eTag(model.eTag);
        }

        public final KeyValueStore.Builder getKeyValueStore() {
            return this.keyValueStore != null ? this.keyValueStore.toBuilder() : null;
        }

        public final void setKeyValueStore(KeyValueStore.BuilderImpl keyValueStore) {
            this.keyValueStore = keyValueStore != null ? keyValueStore.build() : null;
        }

        @Override
        public final Builder keyValueStore(KeyValueStore keyValueStore) {
            this.keyValueStore = keyValueStore;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public DescribeKeyValueStoreResponse build() {
            return new DescribeKeyValueStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKeyValueStoreResponse> {
        public Builder keyValueStore(KeyValueStore var1);

        default public Builder keyValueStore(Consumer<KeyValueStore.Builder> keyValueStore) {
            return this.keyValueStore((KeyValueStore)((KeyValueStore.Builder)KeyValueStore.builder().applyMutation(keyValueStore)).build());
        }

        public Builder eTag(String var1);
    }
}

