/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.ConnectionFunctionSummary;
import software.amazon.awssdk.services.cloudfront.model.FunctionExecutionLogListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionFunctionTestResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionFunctionTestResult> {
    private static final SdkField<ConnectionFunctionSummary> CONNECTION_FUNCTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionFunctionSummary").getter(ConnectionFunctionTestResult.getter(ConnectionFunctionTestResult::connectionFunctionSummary)).setter(ConnectionFunctionTestResult.setter(Builder::connectionFunctionSummary)).constructor(ConnectionFunctionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionSummary").unmarshallLocationName("ConnectionFunctionSummary").build()}).build();
    private static final SdkField<String> COMPUTE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeUtilization").getter(ConnectionFunctionTestResult.getter(ConnectionFunctionTestResult::computeUtilization)).setter(ConnectionFunctionTestResult.setter(Builder::computeUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeUtilization").unmarshallLocationName("ComputeUtilization").build()}).build();
    private static final SdkField<List<String>> CONNECTION_FUNCTION_EXECUTION_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionFunctionExecutionLogs").getter(ConnectionFunctionTestResult.getter(ConnectionFunctionTestResult::connectionFunctionExecutionLogs)).setter(ConnectionFunctionTestResult.setter(Builder::connectionFunctionExecutionLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionExecutionLogs").unmarshallLocationName("ConnectionFunctionExecutionLogs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_FUNCTION_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionFunctionErrorMessage").getter(ConnectionFunctionTestResult.getter(ConnectionFunctionTestResult::connectionFunctionErrorMessage)).setter(ConnectionFunctionTestResult.setter(Builder::connectionFunctionErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionErrorMessage").unmarshallLocationName("ConnectionFunctionErrorMessage").build()}).build();
    private static final SdkField<String> CONNECTION_FUNCTION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionFunctionOutput").getter(ConnectionFunctionTestResult.getter(ConnectionFunctionTestResult::connectionFunctionOutput)).setter(ConnectionFunctionTestResult.setter(Builder::connectionFunctionOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionOutput").unmarshallLocationName("ConnectionFunctionOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FUNCTION_SUMMARY_FIELD, COMPUTE_UTILIZATION_FIELD, CONNECTION_FUNCTION_EXECUTION_LOGS_FIELD, CONNECTION_FUNCTION_ERROR_MESSAGE_FIELD, CONNECTION_FUNCTION_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionFunctionTestResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConnectionFunctionSummary connectionFunctionSummary;
    private final String computeUtilization;
    private final List<String> connectionFunctionExecutionLogs;
    private final String connectionFunctionErrorMessage;
    private final String connectionFunctionOutput;

    private ConnectionFunctionTestResult(BuilderImpl builder) {
        this.connectionFunctionSummary = builder.connectionFunctionSummary;
        this.computeUtilization = builder.computeUtilization;
        this.connectionFunctionExecutionLogs = builder.connectionFunctionExecutionLogs;
        this.connectionFunctionErrorMessage = builder.connectionFunctionErrorMessage;
        this.connectionFunctionOutput = builder.connectionFunctionOutput;
    }

    public final ConnectionFunctionSummary connectionFunctionSummary() {
        return this.connectionFunctionSummary;
    }

    public final String computeUtilization() {
        return this.computeUtilization;
    }

    public final boolean hasConnectionFunctionExecutionLogs() {
        return this.connectionFunctionExecutionLogs != null && !(this.connectionFunctionExecutionLogs instanceof SdkAutoConstructList);
    }

    public final List<String> connectionFunctionExecutionLogs() {
        return this.connectionFunctionExecutionLogs;
    }

    public final String connectionFunctionErrorMessage() {
        return this.connectionFunctionErrorMessage;
    }

    public final String connectionFunctionOutput() {
        return this.connectionFunctionOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionFunctionExecutionLogs() ? this.connectionFunctionExecutionLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionFunctionTestResult)) {
            return false;
        }
        ConnectionFunctionTestResult other = (ConnectionFunctionTestResult)obj;
        return Objects.equals(this.connectionFunctionSummary(), other.connectionFunctionSummary()) && Objects.equals(this.computeUtilization(), other.computeUtilization()) && this.hasConnectionFunctionExecutionLogs() == other.hasConnectionFunctionExecutionLogs() && Objects.equals(this.connectionFunctionExecutionLogs(), other.connectionFunctionExecutionLogs()) && Objects.equals(this.connectionFunctionErrorMessage(), other.connectionFunctionErrorMessage()) && Objects.equals(this.connectionFunctionOutput(), other.connectionFunctionOutput());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionFunctionTestResult").add("ConnectionFunctionSummary", (Object)this.connectionFunctionSummary()).add("ComputeUtilization", (Object)this.computeUtilization()).add("ConnectionFunctionExecutionLogs", (Object)(this.connectionFunctionExecutionLogs() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectionFunctionErrorMessage", (Object)(this.connectionFunctionErrorMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectionFunctionOutput", (Object)(this.connectionFunctionOutput() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionFunctionSummary": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionSummary()));
            }
            case "ComputeUtilization": {
                return Optional.ofNullable(clazz.cast(this.computeUtilization()));
            }
            case "ConnectionFunctionExecutionLogs": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionExecutionLogs()));
            }
            case "ConnectionFunctionErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionErrorMessage()));
            }
            case "ConnectionFunctionOutput": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionFunctionSummary", CONNECTION_FUNCTION_SUMMARY_FIELD);
        map.put("ComputeUtilization", COMPUTE_UTILIZATION_FIELD);
        map.put("ConnectionFunctionExecutionLogs", CONNECTION_FUNCTION_EXECUTION_LOGS_FIELD);
        map.put("ConnectionFunctionErrorMessage", CONNECTION_FUNCTION_ERROR_MESSAGE_FIELD);
        map.put("ConnectionFunctionOutput", CONNECTION_FUNCTION_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionFunctionTestResult, T> g) {
        return obj -> g.apply((ConnectionFunctionTestResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConnectionFunctionSummary connectionFunctionSummary;
        private String computeUtilization;
        private List<String> connectionFunctionExecutionLogs = DefaultSdkAutoConstructList.getInstance();
        private String connectionFunctionErrorMessage;
        private String connectionFunctionOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionFunctionTestResult model) {
            this.connectionFunctionSummary(model.connectionFunctionSummary);
            this.computeUtilization(model.computeUtilization);
            this.connectionFunctionExecutionLogs(model.connectionFunctionExecutionLogs);
            this.connectionFunctionErrorMessage(model.connectionFunctionErrorMessage);
            this.connectionFunctionOutput(model.connectionFunctionOutput);
        }

        public final ConnectionFunctionSummary.Builder getConnectionFunctionSummary() {
            return this.connectionFunctionSummary != null ? this.connectionFunctionSummary.toBuilder() : null;
        }

        public final void setConnectionFunctionSummary(ConnectionFunctionSummary.BuilderImpl connectionFunctionSummary) {
            this.connectionFunctionSummary = connectionFunctionSummary != null ? connectionFunctionSummary.build() : null;
        }

        @Override
        public final Builder connectionFunctionSummary(ConnectionFunctionSummary connectionFunctionSummary) {
            this.connectionFunctionSummary = connectionFunctionSummary;
            return this;
        }

        public final String getComputeUtilization() {
            return this.computeUtilization;
        }

        public final void setComputeUtilization(String computeUtilization) {
            this.computeUtilization = computeUtilization;
        }

        @Override
        public final Builder computeUtilization(String computeUtilization) {
            this.computeUtilization = computeUtilization;
            return this;
        }

        public final Collection<String> getConnectionFunctionExecutionLogs() {
            if (this.connectionFunctionExecutionLogs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectionFunctionExecutionLogs;
        }

        public final void setConnectionFunctionExecutionLogs(Collection<String> connectionFunctionExecutionLogs) {
            this.connectionFunctionExecutionLogs = FunctionExecutionLogListCopier.copy(connectionFunctionExecutionLogs);
        }

        @Override
        public final Builder connectionFunctionExecutionLogs(Collection<String> connectionFunctionExecutionLogs) {
            this.connectionFunctionExecutionLogs = FunctionExecutionLogListCopier.copy(connectionFunctionExecutionLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionFunctionExecutionLogs(String ... connectionFunctionExecutionLogs) {
            this.connectionFunctionExecutionLogs(Arrays.asList(connectionFunctionExecutionLogs));
            return this;
        }

        public final String getConnectionFunctionErrorMessage() {
            return this.connectionFunctionErrorMessage;
        }

        public final void setConnectionFunctionErrorMessage(String connectionFunctionErrorMessage) {
            this.connectionFunctionErrorMessage = connectionFunctionErrorMessage;
        }

        @Override
        public final Builder connectionFunctionErrorMessage(String connectionFunctionErrorMessage) {
            this.connectionFunctionErrorMessage = connectionFunctionErrorMessage;
            return this;
        }

        public final String getConnectionFunctionOutput() {
            return this.connectionFunctionOutput;
        }

        public final void setConnectionFunctionOutput(String connectionFunctionOutput) {
            this.connectionFunctionOutput = connectionFunctionOutput;
        }

        @Override
        public final Builder connectionFunctionOutput(String connectionFunctionOutput) {
            this.connectionFunctionOutput = connectionFunctionOutput;
            return this;
        }

        public ConnectionFunctionTestResult build() {
            return new ConnectionFunctionTestResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionFunctionTestResult> {
        public Builder connectionFunctionSummary(ConnectionFunctionSummary var1);

        default public Builder connectionFunctionSummary(Consumer<ConnectionFunctionSummary.Builder> connectionFunctionSummary) {
            return this.connectionFunctionSummary((ConnectionFunctionSummary)((ConnectionFunctionSummary.Builder)ConnectionFunctionSummary.builder().applyMutation(connectionFunctionSummary)).build());
        }

        public Builder computeUtilization(String var1);

        public Builder connectionFunctionExecutionLogs(Collection<String> var1);

        public Builder connectionFunctionExecutionLogs(String ... var1);

        public Builder connectionFunctionErrorMessage(String var1);

        public Builder connectionFunctionOutput(String var1);
    }
}

