/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionsByTrustStoreRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, ListDistributionsByTrustStoreRequest> {
    private static final SdkField<String> TRUST_STORE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreIdentifier").getter(ListDistributionsByTrustStoreRequest.getter(ListDistributionsByTrustStoreRequest::trustStoreIdentifier)).setter(ListDistributionsByTrustStoreRequest.setter(Builder::trustStoreIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TrustStoreIdentifier").unmarshallLocationName("TrustStoreIdentifier").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDistributionsByTrustStoreRequest.getter(ListDistributionsByTrustStoreRequest::marker)).setter(ListDistributionsByTrustStoreRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListDistributionsByTrustStoreRequest.getter(ListDistributionsByTrustStoreRequest::maxItems)).setter(ListDistributionsByTrustStoreRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_IDENTIFIER_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDistributionsByTrustStoreRequest.memberNameToFieldInitializer();
    private final String trustStoreIdentifier;
    private final String marker;
    private final String maxItems;

    private ListDistributionsByTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreIdentifier = builder.trustStoreIdentifier;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final String trustStoreIdentifier() {
        return this.trustStoreIdentifier;
    }

    public final String marker() {
        return this.marker;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByTrustStoreRequest)) {
            return false;
        }
        ListDistributionsByTrustStoreRequest other = (ListDistributionsByTrustStoreRequest)((Object)obj);
        return Objects.equals(this.trustStoreIdentifier(), other.trustStoreIdentifier()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListDistributionsByTrustStoreRequest").add("TrustStoreIdentifier", (Object)this.trustStoreIdentifier()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreIdentifier": {
                return Optional.ofNullable(clazz.cast(this.trustStoreIdentifier()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TrustStoreIdentifier", TRUST_STORE_IDENTIFIER_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByTrustStoreRequest, T> g) {
        return obj -> g.apply((ListDistributionsByTrustStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String trustStoreIdentifier;
        private String marker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByTrustStoreRequest model) {
            super(model);
            this.trustStoreIdentifier(model.trustStoreIdentifier);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getTrustStoreIdentifier() {
            return this.trustStoreIdentifier;
        }

        public final void setTrustStoreIdentifier(String trustStoreIdentifier) {
            this.trustStoreIdentifier = trustStoreIdentifier;
        }

        @Override
        public final Builder trustStoreIdentifier(String trustStoreIdentifier) {
            this.trustStoreIdentifier = trustStoreIdentifier;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByTrustStoreRequest build() {
            return new ListDistributionsByTrustStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionsByTrustStoreRequest> {
        public Builder trustStoreIdentifier(String var1);

        public Builder marker(String var1);

        public Builder maxItems(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

