/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionFunctionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetConnectionFunctionResponse> {
    private static final SdkField<SdkBytes> CONNECTION_FUNCTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ConnectionFunctionCode").getter(GetConnectionFunctionResponse.getter(GetConnectionFunctionResponse::connectionFunctionCode)).setter(GetConnectionFunctionResponse.setter(Builder::connectionFunctionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionCode").unmarshallLocationName("ConnectionFunctionCode").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetConnectionFunctionResponse.getter(GetConnectionFunctionResponse::eTag)).setter(GetConnectionFunctionResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(GetConnectionFunctionResponse.getter(GetConnectionFunctionResponse::contentType)).setter(GetConnectionFunctionResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").unmarshallLocationName("Content-Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FUNCTION_CODE_FIELD, E_TAG_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConnectionFunctionResponse.memberNameToFieldInitializer();
    private final SdkBytes connectionFunctionCode;
    private final String eTag;
    private final String contentType;

    private GetConnectionFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionFunctionCode = builder.connectionFunctionCode;
        this.eTag = builder.eTag;
        this.contentType = builder.contentType;
    }

    public final SdkBytes connectionFunctionCode() {
        return this.connectionFunctionCode;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String contentType() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionFunctionResponse)) {
            return false;
        }
        GetConnectionFunctionResponse other = (GetConnectionFunctionResponse)((Object)obj);
        return Objects.equals(this.connectionFunctionCode(), other.connectionFunctionCode()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.contentType(), other.contentType());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionFunctionResponse").add("ConnectionFunctionCode", (Object)(this.connectionFunctionCode() == null ? null : "*** Sensitive Data Redacted ***")).add("ETag", (Object)this.eTag()).add("ContentType", (Object)this.contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionFunctionCode": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionCode()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionFunctionCode", CONNECTION_FUNCTION_CODE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionFunctionResponse, T> g) {
        return obj -> g.apply((GetConnectionFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private SdkBytes connectionFunctionCode;
        private String eTag;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionFunctionResponse model) {
            super(model);
            this.connectionFunctionCode(model.connectionFunctionCode);
            this.eTag(model.eTag);
            this.contentType(model.contentType);
        }

        public final ByteBuffer getConnectionFunctionCode() {
            return this.connectionFunctionCode == null ? null : this.connectionFunctionCode.asByteBuffer();
        }

        public final void setConnectionFunctionCode(ByteBuffer connectionFunctionCode) {
            this.connectionFunctionCode(connectionFunctionCode == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)connectionFunctionCode));
        }

        @Override
        public final Builder connectionFunctionCode(SdkBytes connectionFunctionCode) {
            this.connectionFunctionCode = connectionFunctionCode;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public GetConnectionFunctionResponse build() {
            return new GetConnectionFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionFunctionResponse> {
        public Builder connectionFunctionCode(SdkBytes var1);

        public Builder eTag(String var1);

        public Builder contentType(String var1);
    }
}

