/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.DistributionResourceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainConflictsRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, ListDomainConflictsRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(ListDomainConflictsRequest.getter(ListDomainConflictsRequest::domain)).setter(ListDomainConflictsRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("Domain").build()}).build();
    private static final SdkField<DistributionResourceId> DOMAIN_CONTROL_VALIDATION_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainControlValidationResource").getter(ListDomainConflictsRequest.getter(ListDomainConflictsRequest::domainControlValidationResource)).setter(ListDomainConflictsRequest.setter(Builder::domainControlValidationResource)).constructor(DistributionResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControlValidationResource").unmarshallLocationName("DomainControlValidationResource").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListDomainConflictsRequest.getter(ListDomainConflictsRequest::maxItems)).setter(ListDomainConflictsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDomainConflictsRequest.getter(ListDomainConflictsRequest::marker)).setter(ListDomainConflictsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_CONTROL_VALIDATION_RESOURCE_FIELD, MAX_ITEMS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDomainConflictsRequest.memberNameToFieldInitializer();
    private final String domain;
    private final DistributionResourceId domainControlValidationResource;
    private final Integer maxItems;
    private final String marker;

    private ListDomainConflictsRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainControlValidationResource = builder.domainControlValidationResource;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    public final String domain() {
        return this.domain;
    }

    public final DistributionResourceId domainControlValidationResource() {
        return this.domainControlValidationResource;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainControlValidationResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainConflictsRequest)) {
            return false;
        }
        ListDomainConflictsRequest other = (ListDomainConflictsRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainControlValidationResource(), other.domainControlValidationResource()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainConflictsRequest").add("Domain", (Object)this.domain()).add("DomainControlValidationResource", (Object)this.domainControlValidationResource()).add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainControlValidationResource": {
                return Optional.ofNullable(clazz.cast(this.domainControlValidationResource()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainControlValidationResource", DOMAIN_CONTROL_VALIDATION_RESOURCE_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDomainConflictsRequest, T> g) {
        return obj -> g.apply((ListDomainConflictsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String domain;
        private DistributionResourceId domainControlValidationResource;
        private Integer maxItems;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainConflictsRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainControlValidationResource(model.domainControlValidationResource);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final DistributionResourceId.Builder getDomainControlValidationResource() {
            return this.domainControlValidationResource != null ? this.domainControlValidationResource.toBuilder() : null;
        }

        public final void setDomainControlValidationResource(DistributionResourceId.BuilderImpl domainControlValidationResource) {
            this.domainControlValidationResource = domainControlValidationResource != null ? domainControlValidationResource.build() : null;
        }

        @Override
        public final Builder domainControlValidationResource(DistributionResourceId domainControlValidationResource) {
            this.domainControlValidationResource = domainControlValidationResource;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainConflictsRequest build() {
            return new ListDomainConflictsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainConflictsRequest> {
        public Builder domain(String var1);

        public Builder domainControlValidationResource(DistributionResourceId var1);

        default public Builder domainControlValidationResource(Consumer<DistributionResourceId.Builder> domainControlValidationResource) {
            return this.domainControlValidationResource((DistributionResourceId)((DistributionResourceId.Builder)DistributionResourceId.builder().applyMutation(domainControlValidationResource)).build());
        }

        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

