/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference;
import software.amazon.awssdk.services.cloudfront.model.ValidationTokenHost;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedCertificateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedCertificateRequest> {
    private static final SdkField<String> VALIDATION_TOKEN_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationTokenHost").getter(ManagedCertificateRequest.getter(ManagedCertificateRequest::validationTokenHostAsString)).setter(ManagedCertificateRequest.setter(Builder::validationTokenHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationTokenHost").unmarshallLocationName("ValidationTokenHost").build()}).build();
    private static final SdkField<String> PRIMARY_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryDomainName").getter(ManagedCertificateRequest.getter(ManagedCertificateRequest::primaryDomainName)).setter(ManagedCertificateRequest.setter(Builder::primaryDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryDomainName").unmarshallLocationName("PrimaryDomainName").build()}).build();
    private static final SdkField<String> CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateTransparencyLoggingPreference").getter(ManagedCertificateRequest.getter(ManagedCertificateRequest::certificateTransparencyLoggingPreferenceAsString)).setter(ManagedCertificateRequest.setter(Builder::certificateTransparencyLoggingPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateTransparencyLoggingPreference").unmarshallLocationName("CertificateTransparencyLoggingPreference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_TOKEN_HOST_FIELD, PRIMARY_DOMAIN_NAME_FIELD, CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedCertificateRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String validationTokenHost;
    private final String primaryDomainName;
    private final String certificateTransparencyLoggingPreference;

    private ManagedCertificateRequest(BuilderImpl builder) {
        this.validationTokenHost = builder.validationTokenHost;
        this.primaryDomainName = builder.primaryDomainName;
        this.certificateTransparencyLoggingPreference = builder.certificateTransparencyLoggingPreference;
    }

    public final ValidationTokenHost validationTokenHost() {
        return ValidationTokenHost.fromValue(this.validationTokenHost);
    }

    public final String validationTokenHostAsString() {
        return this.validationTokenHost;
    }

    public final String primaryDomainName() {
        return this.primaryDomainName;
    }

    public final CertificateTransparencyLoggingPreference certificateTransparencyLoggingPreference() {
        return CertificateTransparencyLoggingPreference.fromValue(this.certificateTransparencyLoggingPreference);
    }

    public final String certificateTransparencyLoggingPreferenceAsString() {
        return this.certificateTransparencyLoggingPreference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.validationTokenHostAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateTransparencyLoggingPreferenceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedCertificateRequest)) {
            return false;
        }
        ManagedCertificateRequest other = (ManagedCertificateRequest)obj;
        return Objects.equals(this.validationTokenHostAsString(), other.validationTokenHostAsString()) && Objects.equals(this.primaryDomainName(), other.primaryDomainName()) && Objects.equals(this.certificateTransparencyLoggingPreferenceAsString(), other.certificateTransparencyLoggingPreferenceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedCertificateRequest").add("ValidationTokenHost", (Object)this.validationTokenHostAsString()).add("PrimaryDomainName", (Object)this.primaryDomainName()).add("CertificateTransparencyLoggingPreference", (Object)this.certificateTransparencyLoggingPreferenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValidationTokenHost": {
                return Optional.ofNullable(clazz.cast(this.validationTokenHostAsString()));
            }
            case "PrimaryDomainName": {
                return Optional.ofNullable(clazz.cast(this.primaryDomainName()));
            }
            case "CertificateTransparencyLoggingPreference": {
                return Optional.ofNullable(clazz.cast(this.certificateTransparencyLoggingPreferenceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ValidationTokenHost", VALIDATION_TOKEN_HOST_FIELD);
        map.put("PrimaryDomainName", PRIMARY_DOMAIN_NAME_FIELD);
        map.put("CertificateTransparencyLoggingPreference", CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedCertificateRequest, T> g) {
        return obj -> g.apply((ManagedCertificateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String validationTokenHost;
        private String primaryDomainName;
        private String certificateTransparencyLoggingPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedCertificateRequest model) {
            this.validationTokenHost(model.validationTokenHost);
            this.primaryDomainName(model.primaryDomainName);
            this.certificateTransparencyLoggingPreference(model.certificateTransparencyLoggingPreference);
        }

        public final String getValidationTokenHost() {
            return this.validationTokenHost;
        }

        public final void setValidationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
        }

        @Override
        public final Builder validationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
            return this;
        }

        @Override
        public final Builder validationTokenHost(ValidationTokenHost validationTokenHost) {
            this.validationTokenHost(validationTokenHost == null ? null : validationTokenHost.toString());
            return this;
        }

        public final String getPrimaryDomainName() {
            return this.primaryDomainName;
        }

        public final void setPrimaryDomainName(String primaryDomainName) {
            this.primaryDomainName = primaryDomainName;
        }

        @Override
        public final Builder primaryDomainName(String primaryDomainName) {
            this.primaryDomainName = primaryDomainName;
            return this;
        }

        public final String getCertificateTransparencyLoggingPreference() {
            return this.certificateTransparencyLoggingPreference;
        }

        public final void setCertificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
        }

        @Override
        public final Builder certificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
            return this;
        }

        @Override
        public final Builder certificateTransparencyLoggingPreference(CertificateTransparencyLoggingPreference certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference(certificateTransparencyLoggingPreference == null ? null : certificateTransparencyLoggingPreference.toString());
            return this;
        }

        public ManagedCertificateRequest build() {
            return new ManagedCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedCertificateRequest> {
        public Builder validationTokenHost(String var1);

        public Builder validationTokenHost(ValidationTokenHost var1);

        public Builder primaryDomainName(String var1);

        public Builder certificateTransparencyLoggingPreference(String var1);

        public Builder certificateTransparencyLoggingPreference(CertificateTransparencyLoggingPreference var1);
    }
}

