/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectionGroupsRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListConnectionGroupsRequest.Builder, ListConnectionGroupsRequest> {
    private static final SdkField<ConnectionGroupAssociationFilter> ASSOCIATION_FILTER_FIELD = SdkField
            .<ConnectionGroupAssociationFilter> builder(MarshallingType.SDK_POJO)
            .memberName("AssociationFilter")
            .getter(getter(ListConnectionGroupsRequest::associationFilter))
            .setter(setter(Builder::associationFilter))
            .constructor(ConnectionGroupAssociationFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationFilter")
                    .unmarshallLocationName("AssociationFilter").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListConnectionGroupsRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(ListConnectionGroupsRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FILTER_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConnectionGroupAssociationFilter associationFilter;

    private final String marker;

    private final Integer maxItems;

    private ListConnectionGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.associationFilter = builder.associationFilter;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Filter by associated Anycast IP list ID.
     * </p>
     * 
     * @return Filter by associated Anycast IP list ID.
     */
    public final ConnectionGroupAssociationFilter associationFilter() {
        return associationFilter;
    }

    /**
     * <p>
     * The marker for the next set of connection groups to retrieve.
     * </p>
     * 
     * @return The marker for the next set of connection groups to retrieve.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of connection groups to return.
     * </p>
     * 
     * @return The maximum number of connection groups to return.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationFilter());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionGroupsRequest)) {
            return false;
        }
        ListConnectionGroupsRequest other = (ListConnectionGroupsRequest) obj;
        return Objects.equals(associationFilter(), other.associationFilter()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectionGroupsRequest").add("AssociationFilter", associationFilter())
                .add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationFilter":
            return Optional.ofNullable(clazz.cast(associationFilter()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationFilter", ASSOCIATION_FILTER_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionGroupsRequest, T> g) {
        return obj -> g.apply((ListConnectionGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectionGroupsRequest> {
        /**
         * <p>
         * Filter by associated Anycast IP list ID.
         * </p>
         * 
         * @param associationFilter
         *        Filter by associated Anycast IP list ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationFilter(ConnectionGroupAssociationFilter associationFilter);

        /**
         * <p>
         * Filter by associated Anycast IP list ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionGroupAssociationFilter.Builder}
         * avoiding the need to create one manually via {@link ConnectionGroupAssociationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionGroupAssociationFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #associationFilter(ConnectionGroupAssociationFilter)}.
         * 
         * @param associationFilter
         *        a consumer that will call methods on {@link ConnectionGroupAssociationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationFilter(ConnectionGroupAssociationFilter)
         */
        default Builder associationFilter(Consumer<ConnectionGroupAssociationFilter.Builder> associationFilter) {
            return associationFilter(ConnectionGroupAssociationFilter.builder().applyMutation(associationFilter).build());
        }

        /**
         * <p>
         * The marker for the next set of connection groups to retrieve.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of connection groups to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of connection groups to return.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of connection groups to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private ConnectionGroupAssociationFilter associationFilter;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionGroupsRequest model) {
            super(model);
            associationFilter(model.associationFilter);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final ConnectionGroupAssociationFilter.Builder getAssociationFilter() {
            return associationFilter != null ? associationFilter.toBuilder() : null;
        }

        public final void setAssociationFilter(ConnectionGroupAssociationFilter.BuilderImpl associationFilter) {
            this.associationFilter = associationFilter != null ? associationFilter.build() : null;
        }

        @Override
        public final Builder associationFilter(ConnectionGroupAssociationFilter associationFilter) {
            this.associationFilter = associationFilter;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectionGroupsRequest build() {
            return new ListConnectionGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
