/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of CloudFront VPC origins.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcOriginList implements SdkPojo, Serializable, ToCopyableBuilder<VpcOriginList.Builder, VpcOriginList> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(VpcOriginList::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(VpcOriginList::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(VpcOriginList::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(VpcOriginList::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(VpcOriginList::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<VpcOriginSummary>> ITEMS_FIELD = SdkField
            .<List<VpcOriginSummary>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(VpcOriginList::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcOriginSummary")
                            .memberFieldInfo(
                                    SdkField.<VpcOriginSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcOriginSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcOriginSummary").unmarshallLocationName("VpcOriginSummary")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            NEXT_MARKER_FIELD, MAX_ITEMS_FIELD, IS_TRUNCATED_FIELD, QUANTITY_FIELD, ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String marker;

    private final String nextMarker;

    private final Integer maxItems;

    private final Boolean isTruncated;

    private final Integer quantity;

    private final List<VpcOriginSummary> items;

    private VpcOriginList(BuilderImpl builder) {
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The marker associated with the VPC origins list.
     * </p>
     * 
     * @return The marker associated with the VPC origins list.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The next marker associated with the VPC origins list.
     * </p>
     * 
     * @return The next marker associated with the VPC origins list.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of items included in the list.
     * </p>
     * 
     * @return The maximum number of items included in the list.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * A flag that indicates whether more VPC origins remain to be listed. If your results were truncated, you can make
     * a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more VPC origins in
     * the list.
     * </p>
     * 
     * @return A flag that indicates whether more VPC origins remain to be listed. If your results were truncated, you
     *         can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more
     *         VPC origins in the list.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The number of VPC origins in the list.
     * </p>
     * 
     * @return The number of VPC origins in the list.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The items of the VPC origins list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The items of the VPC origins list.
     */
    public final List<VpcOriginSummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOriginList)) {
            return false;
        }
        VpcOriginList other = (VpcOriginList) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(quantity(), other.quantity()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcOriginList").add("Marker", marker()).add("NextMarker", nextMarker())
                .add("MaxItems", maxItems()).add("IsTruncated", isTruncated()).add("Quantity", quantity())
                .add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("Quantity", QUANTITY_FIELD);
        map.put("Items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcOriginList, T> g) {
        return obj -> g.apply((VpcOriginList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcOriginList> {
        /**
         * <p>
         * The marker associated with the VPC origins list.
         * </p>
         * 
         * @param marker
         *        The marker associated with the VPC origins list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The next marker associated with the VPC origins list.
         * </p>
         * 
         * @param nextMarker
         *        The next marker associated with the VPC origins list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of items included in the list.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of items included in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * A flag that indicates whether more VPC origins remain to be listed. If your results were truncated, you can
         * make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more VPC
         * origins in the list.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more VPC origins remain to be listed. If your results were truncated,
         *        you can make a follow-up pagination request using the <code>Marker</code> request parameter to
         *        retrieve more VPC origins in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The number of VPC origins in the list.
         * </p>
         * 
         * @param quantity
         *        The number of VPC origins in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The items of the VPC origins list.
         * </p>
         * 
         * @param items
         *        The items of the VPC origins list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<VpcOriginSummary> items);

        /**
         * <p>
         * The items of the VPC origins list.
         * </p>
         * 
         * @param items
         *        The items of the VPC origins list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(VpcOriginSummary... items);

        /**
         * <p>
         * The items of the VPC origins list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<VpcOriginSummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<VpcOriginSummary>)
         */
        Builder items(Consumer<VpcOriginSummary.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private String nextMarker;

        private Integer maxItems;

        private Boolean isTruncated;

        private Integer quantity;

        private List<VpcOriginSummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOriginList model) {
            marker(model.marker);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            isTruncated(model.isTruncated);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<VpcOriginSummary.Builder> getItems() {
            List<VpcOriginSummary.Builder> result = VpcOriginSummaryListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<VpcOriginSummary.BuilderImpl> items) {
            this.items = VpcOriginSummaryListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<VpcOriginSummary> items) {
            this.items = VpcOriginSummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(VpcOriginSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<VpcOriginSummary.Builder>... items) {
            items(Stream.of(items).map(c -> VpcOriginSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public VpcOriginList build() {
            return new VpcOriginList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
