/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.DomainItem;

final class DomainListCopier {
    DomainListCopier() {
    }

    static List<DomainItem> copy(Collection<? extends DomainItem> domainListParam) {
        Object list;
        if (domainListParam == null || domainListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(domainListParam.size());
            domainListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DomainItem> copyFromBuilder(Collection<? extends DomainItem.Builder> domainListParam) {
        Object list;
        if (domainListParam == null || domainListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(domainListParam.size());
            domainListParam.forEach(entry -> {
                DomainItem member = entry == null ? null : (DomainItem)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DomainItem.Builder> copyToBuilder(Collection<? extends DomainItem> domainListParam) {
        Object list;
        if (domainListParam == null || domainListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(domainListParam.size());
            domainListParam.forEach(entry -> {
                DomainItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

