/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DistributionResourceType {
    DISTRIBUTION("distribution"),
    DISTRIBUTION_TENANT("distribution-tenant"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DistributionResourceType> VALUE_MAP;
    private final String value;

    private DistributionResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DistributionResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DistributionResourceType> knownValues() {
        EnumSet<DistributionResourceType> knownValues = EnumSet.allOf(DistributionResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DistributionResourceType.class, DistributionResourceType::toString);
    }
}

