/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRealtimeLogConfigResponse extends CloudFrontResponse implements
        ToCopyableBuilder<UpdateRealtimeLogConfigResponse.Builder, UpdateRealtimeLogConfigResponse> {
    private static final SdkField<RealtimeLogConfig> REALTIME_LOG_CONFIG_FIELD = SdkField
            .<RealtimeLogConfig> builder(MarshallingType.SDK_POJO)
            .memberName("RealtimeLogConfig")
            .getter(getter(UpdateRealtimeLogConfigResponse::realtimeLogConfig))
            .setter(setter(Builder::realtimeLogConfig))
            .constructor(RealtimeLogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfig")
                    .unmarshallLocationName("RealtimeLogConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REALTIME_LOG_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RealtimeLogConfig realtimeLogConfig;

    private UpdateRealtimeLogConfigResponse(BuilderImpl builder) {
        super(builder);
        this.realtimeLogConfig = builder.realtimeLogConfig;
    }

    /**
     * <p>
     * A real-time log configuration.
     * </p>
     * 
     * @return A real-time log configuration.
     */
    public final RealtimeLogConfig realtimeLogConfig() {
        return realtimeLogConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(realtimeLogConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRealtimeLogConfigResponse)) {
            return false;
        }
        UpdateRealtimeLogConfigResponse other = (UpdateRealtimeLogConfigResponse) obj;
        return Objects.equals(realtimeLogConfig(), other.realtimeLogConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRealtimeLogConfigResponse").add("RealtimeLogConfig", realtimeLogConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RealtimeLogConfig":
            return Optional.ofNullable(clazz.cast(realtimeLogConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RealtimeLogConfig", REALTIME_LOG_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRealtimeLogConfigResponse, T> g) {
        return obj -> g.apply((UpdateRealtimeLogConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRealtimeLogConfigResponse> {
        /**
         * <p>
         * A real-time log configuration.
         * </p>
         * 
         * @param realtimeLogConfig
         *        A real-time log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeLogConfig(RealtimeLogConfig realtimeLogConfig);

        /**
         * <p>
         * A real-time log configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealtimeLogConfig.Builder} avoiding the
         * need to create one manually via {@link RealtimeLogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealtimeLogConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #realtimeLogConfig(RealtimeLogConfig)}.
         * 
         * @param realtimeLogConfig
         *        a consumer that will call methods on {@link RealtimeLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realtimeLogConfig(RealtimeLogConfig)
         */
        default Builder realtimeLogConfig(Consumer<RealtimeLogConfig.Builder> realtimeLogConfig) {
            return realtimeLogConfig(RealtimeLogConfig.builder().applyMutation(realtimeLogConfig).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private RealtimeLogConfig realtimeLogConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRealtimeLogConfigResponse model) {
            super(model);
            realtimeLogConfig(model.realtimeLogConfig);
        }

        public final RealtimeLogConfig.Builder getRealtimeLogConfig() {
            return realtimeLogConfig != null ? realtimeLogConfig.toBuilder() : null;
        }

        public final void setRealtimeLogConfig(RealtimeLogConfig.BuilderImpl realtimeLogConfig) {
            this.realtimeLogConfig = realtimeLogConfig != null ? realtimeLogConfig.build() : null;
        }

        @Override
        public final Builder realtimeLogConfig(RealtimeLogConfig realtimeLogConfig) {
            this.realtimeLogConfig = realtimeLogConfig;
            return this;
        }

        @Override
        public UpdateRealtimeLogConfigResponse build() {
            return new UpdateRealtimeLogConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
