/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCloudFrontOriginAccessIdentitiesResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListCloudFrontOriginAccessIdentitiesResponse.Builder, ListCloudFrontOriginAccessIdentitiesResponse> {
    private static final SdkField<CloudFrontOriginAccessIdentityList> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_LIST_FIELD = SdkField
            .<CloudFrontOriginAccessIdentityList> builder(MarshallingType.SDK_POJO)
            .memberName("CloudFrontOriginAccessIdentityList")
            .getter(getter(ListCloudFrontOriginAccessIdentitiesResponse::cloudFrontOriginAccessIdentityList))
            .setter(setter(Builder::cloudFrontOriginAccessIdentityList))
            .constructor(CloudFrontOriginAccessIdentityList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontOriginAccessIdentityList")
                    .unmarshallLocationName("CloudFrontOriginAccessIdentityList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList;

    private ListCloudFrontOriginAccessIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityList = builder.cloudFrontOriginAccessIdentityList;
    }

    /**
     * <p>
     * The <code>CloudFrontOriginAccessIdentityList</code> type.
     * </p>
     * 
     * @return The <code>CloudFrontOriginAccessIdentityList</code> type.
     */
    public final CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList() {
        return cloudFrontOriginAccessIdentityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontOriginAccessIdentityList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudFrontOriginAccessIdentitiesResponse)) {
            return false;
        }
        ListCloudFrontOriginAccessIdentitiesResponse other = (ListCloudFrontOriginAccessIdentitiesResponse) obj;
        return Objects.equals(cloudFrontOriginAccessIdentityList(), other.cloudFrontOriginAccessIdentityList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCloudFrontOriginAccessIdentitiesResponse")
                .add("CloudFrontOriginAccessIdentityList", cloudFrontOriginAccessIdentityList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentityList":
            return Optional.ofNullable(clazz.cast(cloudFrontOriginAccessIdentityList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudFrontOriginAccessIdentityList", CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCloudFrontOriginAccessIdentitiesResponse, T> g) {
        return obj -> g.apply((ListCloudFrontOriginAccessIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCloudFrontOriginAccessIdentitiesResponse> {
        /**
         * <p>
         * The <code>CloudFrontOriginAccessIdentityList</code> type.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityList
         *        The <code>CloudFrontOriginAccessIdentityList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList);

        /**
         * <p>
         * The <code>CloudFrontOriginAccessIdentityList</code> type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CloudFrontOriginAccessIdentityList.Builder} avoiding the need to create one manually via
         * {@link CloudFrontOriginAccessIdentityList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudFrontOriginAccessIdentityList.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList)}.
         * 
         * @param cloudFrontOriginAccessIdentityList
         *        a consumer that will call methods on {@link CloudFrontOriginAccessIdentityList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList)
         */
        default Builder cloudFrontOriginAccessIdentityList(
                Consumer<CloudFrontOriginAccessIdentityList.Builder> cloudFrontOriginAccessIdentityList) {
            return cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList.builder()
                    .applyMutation(cloudFrontOriginAccessIdentityList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudFrontOriginAccessIdentitiesResponse model) {
            super(model);
            cloudFrontOriginAccessIdentityList(model.cloudFrontOriginAccessIdentityList);
        }

        public final CloudFrontOriginAccessIdentityList.Builder getCloudFrontOriginAccessIdentityList() {
            return cloudFrontOriginAccessIdentityList != null ? cloudFrontOriginAccessIdentityList.toBuilder() : null;
        }

        public final void setCloudFrontOriginAccessIdentityList(
                CloudFrontOriginAccessIdentityList.BuilderImpl cloudFrontOriginAccessIdentityList) {
            this.cloudFrontOriginAccessIdentityList = cloudFrontOriginAccessIdentityList != null ? cloudFrontOriginAccessIdentityList
                    .build() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityList(
                CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList) {
            this.cloudFrontOriginAccessIdentityList = cloudFrontOriginAccessIdentityList;
            return this;
        }

        @Override
        public ListCloudFrontOriginAccessIdentitiesResponse build() {
            return new ListCloudFrontOriginAccessIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
