/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKeyGroupResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetKeyGroupResponse.Builder, GetKeyGroupResponse> {
    private static final SdkField<KeyGroup> KEY_GROUP_FIELD = SdkField
            .<KeyGroup> builder(MarshallingType.SDK_POJO)
            .memberName("KeyGroup")
            .getter(getter(GetKeyGroupResponse::keyGroup))
            .setter(setter(Builder::keyGroup))
            .constructor(KeyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroup")
                    .unmarshallLocationName("KeyGroup").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetKeyGroupResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_GROUP_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final KeyGroup keyGroup;

    private final String eTag;

    private GetKeyGroupResponse(BuilderImpl builder) {
        super(builder);
        this.keyGroup = builder.keyGroup;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The key group.
     * </p>
     * 
     * @return The key group.
     */
    public final KeyGroup keyGroup() {
        return keyGroup;
    }

    /**
     * <p>
     * The identifier for this version of the key group.
     * </p>
     * 
     * @return The identifier for this version of the key group.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyGroup());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyGroupResponse)) {
            return false;
        }
        GetKeyGroupResponse other = (GetKeyGroupResponse) obj;
        return Objects.equals(keyGroup(), other.keyGroup()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKeyGroupResponse").add("KeyGroup", keyGroup()).add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyGroup":
            return Optional.ofNullable(clazz.cast(keyGroup()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyGroup", KEY_GROUP_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKeyGroupResponse, T> g) {
        return obj -> g.apply((GetKeyGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKeyGroupResponse> {
        /**
         * <p>
         * The key group.
         * </p>
         * 
         * @param keyGroup
         *        The key group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyGroup(KeyGroup keyGroup);

        /**
         * <p>
         * The key group.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyGroup.Builder} avoiding the need to
         * create one manually via {@link KeyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyGroup.Builder#build()} is called immediately and its result is
         * passed to {@link #keyGroup(KeyGroup)}.
         * 
         * @param keyGroup
         *        a consumer that will call methods on {@link KeyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyGroup(KeyGroup)
         */
        default Builder keyGroup(Consumer<KeyGroup.Builder> keyGroup) {
            return keyGroup(KeyGroup.builder().applyMutation(keyGroup).build());
        }

        /**
         * <p>
         * The identifier for this version of the key group.
         * </p>
         * 
         * @param eTag
         *        The identifier for this version of the key group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private KeyGroup keyGroup;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyGroupResponse model) {
            super(model);
            keyGroup(model.keyGroup);
            eTag(model.eTag);
        }

        public final KeyGroup.Builder getKeyGroup() {
            return keyGroup != null ? keyGroup.toBuilder() : null;
        }

        public final void setKeyGroup(KeyGroup.BuilderImpl keyGroup) {
            this.keyGroup = keyGroup != null ? keyGroup.build() : null;
        }

        @Override
        public final Builder keyGroup(KeyGroup keyGroup) {
            this.keyGroup = keyGroup;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetKeyGroupResponse build() {
            return new GetKeyGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
