/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration for a continuous deployment policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousDeploymentPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousDeploymentPolicyConfig.Builder, ContinuousDeploymentPolicyConfig> {
    private static final SdkField<StagingDistributionDnsNames> STAGING_DISTRIBUTION_DNS_NAMES_FIELD = SdkField
            .<StagingDistributionDnsNames> builder(MarshallingType.SDK_POJO)
            .memberName("StagingDistributionDnsNames")
            .getter(getter(ContinuousDeploymentPolicyConfig::stagingDistributionDnsNames))
            .setter(setter(Builder::stagingDistributionDnsNames))
            .constructor(StagingDistributionDnsNames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagingDistributionDnsNames")
                    .unmarshallLocationName("StagingDistributionDnsNames").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(ContinuousDeploymentPolicyConfig::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<TrafficConfig> TRAFFIC_CONFIG_FIELD = SdkField
            .<TrafficConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficConfig")
            .getter(getter(ContinuousDeploymentPolicyConfig::trafficConfig))
            .setter(setter(Builder::trafficConfig))
            .constructor(TrafficConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficConfig")
                    .unmarshallLocationName("TrafficConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STAGING_DISTRIBUTION_DNS_NAMES_FIELD, ENABLED_FIELD, TRAFFIC_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StagingDistributionDnsNames stagingDistributionDnsNames;

    private final Boolean enabled;

    private final TrafficConfig trafficConfig;

    private ContinuousDeploymentPolicyConfig(BuilderImpl builder) {
        this.stagingDistributionDnsNames = builder.stagingDistributionDnsNames;
        this.enabled = builder.enabled;
        this.trafficConfig = builder.trafficConfig;
    }

    /**
     * <p>
     * The CloudFront domain name of the staging distribution. For example: <code>d111111abcdef8.cloudfront.net</code>.
     * </p>
     * 
     * @return The CloudFront domain name of the staging distribution. For example:
     *         <code>d111111abcdef8.cloudfront.net</code>.
     */
    public final StagingDistributionDnsNames stagingDistributionDnsNames() {
        return stagingDistributionDnsNames;
    }

    /**
     * <p>
     * A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is
     * <code>true</code>, this policy is enabled and in effect. When this value is <code>false</code>, this policy is
     * not enabled and has no effect.
     * </p>
     * 
     * @return A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this
     *         value is <code>true</code>, this policy is enabled and in effect. When this value is <code>false</code>,
     *         this policy is not enabled and has no effect.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Contains the parameters for routing production traffic from your primary to staging distributions.
     * </p>
     * 
     * @return Contains the parameters for routing production traffic from your primary to staging distributions.
     */
    public final TrafficConfig trafficConfig() {
        return trafficConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stagingDistributionDnsNames());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(trafficConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousDeploymentPolicyConfig)) {
            return false;
        }
        ContinuousDeploymentPolicyConfig other = (ContinuousDeploymentPolicyConfig) obj;
        return Objects.equals(stagingDistributionDnsNames(), other.stagingDistributionDnsNames())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(trafficConfig(), other.trafficConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousDeploymentPolicyConfig")
                .add("StagingDistributionDnsNames", stagingDistributionDnsNames()).add("Enabled", enabled())
                .add("TrafficConfig", trafficConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StagingDistributionDnsNames":
            return Optional.ofNullable(clazz.cast(stagingDistributionDnsNames()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "TrafficConfig":
            return Optional.ofNullable(clazz.cast(trafficConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StagingDistributionDnsNames", STAGING_DISTRIBUTION_DNS_NAMES_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("TrafficConfig", TRAFFIC_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContinuousDeploymentPolicyConfig, T> g) {
        return obj -> g.apply((ContinuousDeploymentPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousDeploymentPolicyConfig> {
        /**
         * <p>
         * The CloudFront domain name of the staging distribution. For example:
         * <code>d111111abcdef8.cloudfront.net</code>.
         * </p>
         * 
         * @param stagingDistributionDnsNames
         *        The CloudFront domain name of the staging distribution. For example:
         *        <code>d111111abcdef8.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingDistributionDnsNames(StagingDistributionDnsNames stagingDistributionDnsNames);

        /**
         * <p>
         * The CloudFront domain name of the staging distribution. For example:
         * <code>d111111abcdef8.cloudfront.net</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link StagingDistributionDnsNames.Builder}
         * avoiding the need to create one manually via {@link StagingDistributionDnsNames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StagingDistributionDnsNames.Builder#build()} is called
         * immediately and its result is passed to {@link #stagingDistributionDnsNames(StagingDistributionDnsNames)}.
         * 
         * @param stagingDistributionDnsNames
         *        a consumer that will call methods on {@link StagingDistributionDnsNames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stagingDistributionDnsNames(StagingDistributionDnsNames)
         */
        default Builder stagingDistributionDnsNames(Consumer<StagingDistributionDnsNames.Builder> stagingDistributionDnsNames) {
            return stagingDistributionDnsNames(StagingDistributionDnsNames.builder().applyMutation(stagingDistributionDnsNames)
                    .build());
        }

        /**
         * <p>
         * A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is
         * <code>true</code>, this policy is enabled and in effect. When this value is <code>false</code>, this policy
         * is not enabled and has no effect.
         * </p>
         * 
         * @param enabled
         *        A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this
         *        value is <code>true</code>, this policy is enabled and in effect. When this value is
         *        <code>false</code>, this policy is not enabled and has no effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Contains the parameters for routing production traffic from your primary to staging distributions.
         * </p>
         * 
         * @param trafficConfig
         *        Contains the parameters for routing production traffic from your primary to staging distributions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficConfig(TrafficConfig trafficConfig);

        /**
         * <p>
         * Contains the parameters for routing production traffic from your primary to staging distributions.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficConfig.Builder} avoiding the need
         * to create one manually via {@link TrafficConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #trafficConfig(TrafficConfig)}.
         * 
         * @param trafficConfig
         *        a consumer that will call methods on {@link TrafficConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficConfig(TrafficConfig)
         */
        default Builder trafficConfig(Consumer<TrafficConfig.Builder> trafficConfig) {
            return trafficConfig(TrafficConfig.builder().applyMutation(trafficConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StagingDistributionDnsNames stagingDistributionDnsNames;

        private Boolean enabled;

        private TrafficConfig trafficConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousDeploymentPolicyConfig model) {
            stagingDistributionDnsNames(model.stagingDistributionDnsNames);
            enabled(model.enabled);
            trafficConfig(model.trafficConfig);
        }

        public final StagingDistributionDnsNames.Builder getStagingDistributionDnsNames() {
            return stagingDistributionDnsNames != null ? stagingDistributionDnsNames.toBuilder() : null;
        }

        public final void setStagingDistributionDnsNames(StagingDistributionDnsNames.BuilderImpl stagingDistributionDnsNames) {
            this.stagingDistributionDnsNames = stagingDistributionDnsNames != null ? stagingDistributionDnsNames.build() : null;
        }

        @Override
        public final Builder stagingDistributionDnsNames(StagingDistributionDnsNames stagingDistributionDnsNames) {
            this.stagingDistributionDnsNames = stagingDistributionDnsNames;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final TrafficConfig.Builder getTrafficConfig() {
            return trafficConfig != null ? trafficConfig.toBuilder() : null;
        }

        public final void setTrafficConfig(TrafficConfig.BuilderImpl trafficConfig) {
            this.trafficConfig = trafficConfig != null ? trafficConfig.build() : null;
        }

        @Override
        public final Builder trafficConfig(TrafficConfig trafficConfig) {
            this.trafficConfig = trafficConfig;
            return this;
        }

        @Override
        public ContinuousDeploymentPolicyConfig build() {
            return new ContinuousDeploymentPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
