/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.FrameOptionsList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseHeadersPolicyFrameOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseHeadersPolicyFrameOptions> {
    private static final SdkField<Boolean> OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Override").getter(ResponseHeadersPolicyFrameOptions.getter(ResponseHeadersPolicyFrameOptions::override)).setter(ResponseHeadersPolicyFrameOptions.setter(Builder::override)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Override").unmarshallLocationName("Override").build()}).build();
    private static final SdkField<String> FRAME_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameOption").getter(ResponseHeadersPolicyFrameOptions.getter(ResponseHeadersPolicyFrameOptions::frameOptionAsString)).setter(ResponseHeadersPolicyFrameOptions.setter(Builder::frameOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameOption").unmarshallLocationName("FrameOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_FIELD, FRAME_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Override", OVERRIDE_FIELD);
            this.put("FrameOption", FRAME_OPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean override;
    private final String frameOption;

    private ResponseHeadersPolicyFrameOptions(BuilderImpl builder) {
        this.override = builder.override;
        this.frameOption = builder.frameOption;
    }

    public final Boolean override() {
        return this.override;
    }

    public final FrameOptionsList frameOption() {
        return FrameOptionsList.fromValue(this.frameOption);
    }

    public final String frameOptionAsString() {
        return this.frameOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.override());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyFrameOptions)) {
            return false;
        }
        ResponseHeadersPolicyFrameOptions other = (ResponseHeadersPolicyFrameOptions)obj;
        return Objects.equals(this.override(), other.override()) && Objects.equals(this.frameOptionAsString(), other.frameOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseHeadersPolicyFrameOptions").add("Override", (Object)this.override()).add("FrameOption", (Object)this.frameOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Override": {
                return Optional.ofNullable(clazz.cast(this.override()));
            }
            case "FrameOption": {
                return Optional.ofNullable(clazz.cast(this.frameOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyFrameOptions, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyFrameOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean override;
        private String frameOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyFrameOptions model) {
            this.override(model.override);
            this.frameOption(model.frameOption);
        }

        public final Boolean getOverride() {
            return this.override;
        }

        public final void setOverride(Boolean override) {
            this.override = override;
        }

        @Override
        public final Builder override(Boolean override) {
            this.override = override;
            return this;
        }

        public final String getFrameOption() {
            return this.frameOption;
        }

        public final void setFrameOption(String frameOption) {
            this.frameOption = frameOption;
        }

        @Override
        public final Builder frameOption(String frameOption) {
            this.frameOption = frameOption;
            return this;
        }

        @Override
        public final Builder frameOption(FrameOptionsList frameOption) {
            this.frameOption(frameOption == null ? null : frameOption.toString());
            return this;
        }

        public ResponseHeadersPolicyFrameOptions build() {
            return new ResponseHeadersPolicyFrameOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseHeadersPolicyFrameOptions> {
        public Builder override(Boolean var1);

        public Builder frameOption(String var1);

        public Builder frameOption(FrameOptionsList var1);
    }
}

