/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Invalidation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Invalidation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Invalidation.getter(Invalidation::id)).setter(Invalidation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Invalidation.getter(Invalidation::status)).setter(Invalidation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(Invalidation.getter(Invalidation::createTime)).setter(Invalidation.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("CreateTime").build()}).build();
    private static final SdkField<InvalidationBatch> INVALIDATION_BATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvalidationBatch").getter(Invalidation.getter(Invalidation::invalidationBatch)).setter(Invalidation.setter(Builder::invalidationBatch)).constructor(InvalidationBatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidationBatch").unmarshallLocationName("InvalidationBatch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD, CREATE_TIME_FIELD, INVALIDATION_BATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("InvalidationBatch", INVALIDATION_BATCH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String status;
    private final Instant createTime;
    private final InvalidationBatch invalidationBatch;

    private Invalidation(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.invalidationBatch = builder.invalidationBatch;
    }

    public final String id() {
        return this.id;
    }

    public final String status() {
        return this.status;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final InvalidationBatch invalidationBatch() {
        return this.invalidationBatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidationBatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invalidation)) {
            return false;
        }
        Invalidation other = (Invalidation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.invalidationBatch(), other.invalidationBatch());
    }

    public final String toString() {
        return ToString.builder((String)"Invalidation").add("Id", (Object)this.id()).add("Status", (Object)this.status()).add("CreateTime", (Object)this.createTime()).add("InvalidationBatch", (Object)this.invalidationBatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "InvalidationBatch": {
                return Optional.ofNullable(clazz.cast(this.invalidationBatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Invalidation, T> g) {
        return obj -> g.apply((Invalidation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private Instant createTime;
        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(Invalidation model) {
            this.id(model.id);
            this.status(model.status);
            this.createTime(model.createTime);
            this.invalidationBatch(model.invalidationBatch);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return this.invalidationBatch != null ? this.invalidationBatch.toBuilder() : null;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public Invalidation build() {
            return new Invalidation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Invalidation> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder createTime(Instant var1);

        public Builder invalidationBatch(InvalidationBatch var1);

        default public Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return this.invalidationBatch((InvalidationBatch)((InvalidationBatch.Builder)InvalidationBatch.builder().applyMutation(invalidationBatch)).build());
        }
    }
}

