/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyDistributionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CopyDistributionRequest> {
    private static final SdkField<String> PRIMARY_DISTRIBUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryDistributionId").getter(CopyDistributionRequest.getter(CopyDistributionRequest::primaryDistributionId)).setter(CopyDistributionRequest.setter(Builder::primaryDistributionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PrimaryDistributionId").unmarshallLocationName("PrimaryDistributionId").build()}).build();
    private static final SdkField<Boolean> STAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Staging").getter(CopyDistributionRequest.getter(CopyDistributionRequest::staging)).setter(CopyDistributionRequest.setter(Builder::staging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Staging").unmarshallLocationName("Staging").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(CopyDistributionRequest.getter(CopyDistributionRequest::ifMatch)).setter(CopyDistributionRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerReference").getter(CopyDistributionRequest.getter(CopyDistributionRequest::callerReference)).setter(CopyDistributionRequest.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CopyDistributionRequest.getter(CopyDistributionRequest::enabled)).setter(CopyDistributionRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_DISTRIBUTION_ID_FIELD, STAGING_FIELD, IF_MATCH_FIELD, CALLER_REFERENCE_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopyDistributionRequest.memberNameToFieldInitializer();
    private final String primaryDistributionId;
    private final Boolean staging;
    private final String ifMatch;
    private final String callerReference;
    private final Boolean enabled;

    private CopyDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.primaryDistributionId = builder.primaryDistributionId;
        this.staging = builder.staging;
        this.ifMatch = builder.ifMatch;
        this.callerReference = builder.callerReference;
        this.enabled = builder.enabled;
    }

    public final String primaryDistributionId() {
        return this.primaryDistributionId;
    }

    public final Boolean staging() {
        return this.staging;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final String callerReference() {
        return this.callerReference;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryDistributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.staging());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDistributionRequest)) {
            return false;
        }
        CopyDistributionRequest other = (CopyDistributionRequest)((Object)obj);
        return Objects.equals(this.primaryDistributionId(), other.primaryDistributionId()) && Objects.equals(this.staging(), other.staging()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"CopyDistributionRequest").add("PrimaryDistributionId", (Object)this.primaryDistributionId()).add("Staging", (Object)this.staging()).add("IfMatch", (Object)this.ifMatch()).add("CallerReference", (Object)this.callerReference()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryDistributionId": {
                return Optional.ofNullable(clazz.cast(this.primaryDistributionId()));
            }
            case "Staging": {
                return Optional.ofNullable(clazz.cast(this.staging()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrimaryDistributionId", PRIMARY_DISTRIBUTION_ID_FIELD);
        map.put("Staging", STAGING_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("CallerReference", CALLER_REFERENCE_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyDistributionRequest, T> g) {
        return obj -> g.apply((CopyDistributionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String primaryDistributionId;
        private Boolean staging;
        private String ifMatch;
        private String callerReference;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDistributionRequest model) {
            super(model);
            this.primaryDistributionId(model.primaryDistributionId);
            this.staging(model.staging);
            this.ifMatch(model.ifMatch);
            this.callerReference(model.callerReference);
            this.enabled(model.enabled);
        }

        public final String getPrimaryDistributionId() {
            return this.primaryDistributionId;
        }

        public final void setPrimaryDistributionId(String primaryDistributionId) {
            this.primaryDistributionId = primaryDistributionId;
        }

        @Override
        public final Builder primaryDistributionId(String primaryDistributionId) {
            this.primaryDistributionId = primaryDistributionId;
            return this;
        }

        public final Boolean getStaging() {
            return this.staging;
        }

        public final void setStaging(Boolean staging) {
            this.staging = staging;
        }

        @Override
        public final Builder staging(Boolean staging) {
            this.staging = staging;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDistributionRequest build() {
            return new CopyDistributionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyDistributionRequest> {
        public Builder primaryDistributionId(String var1);

        public Builder staging(Boolean var1);

        public Builder ifMatch(String var1);

        public Builder callerReference(String var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

