/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.VpcOriginList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcOriginsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListVpcOriginsResponse> {
    private static final SdkField<VpcOriginList> VPC_ORIGIN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOriginList").getter(ListVpcOriginsResponse.getter(ListVpcOriginsResponse::vpcOriginList)).setter(ListVpcOriginsResponse.setter(Builder::vpcOriginList)).constructor(VpcOriginList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginList").unmarshallLocationName("VpcOriginList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ORIGIN_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VpcOriginList", VPC_ORIGIN_LIST_FIELD);
        }
    });
    private final VpcOriginList vpcOriginList;

    private ListVpcOriginsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcOriginList = builder.vpcOriginList;
    }

    public final VpcOriginList vpcOriginList() {
        return this.vpcOriginList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOriginList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcOriginsResponse)) {
            return false;
        }
        ListVpcOriginsResponse other = (ListVpcOriginsResponse)((Object)obj);
        return Objects.equals(this.vpcOriginList(), other.vpcOriginList());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpcOriginsResponse").add("VpcOriginList", (Object)this.vpcOriginList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcOriginList": {
                return Optional.ofNullable(clazz.cast(this.vpcOriginList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListVpcOriginsResponse, T> g) {
        return obj -> g.apply((ListVpcOriginsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private VpcOriginList vpcOriginList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcOriginsResponse model) {
            super(model);
            this.vpcOriginList(model.vpcOriginList);
        }

        public final VpcOriginList.Builder getVpcOriginList() {
            return this.vpcOriginList != null ? this.vpcOriginList.toBuilder() : null;
        }

        public final void setVpcOriginList(VpcOriginList.BuilderImpl vpcOriginList) {
            this.vpcOriginList = vpcOriginList != null ? vpcOriginList.build() : null;
        }

        @Override
        public final Builder vpcOriginList(VpcOriginList vpcOriginList) {
            this.vpcOriginList = vpcOriginList;
            return this;
        }

        @Override
        public ListVpcOriginsResponse build() {
            return new ListVpcOriginsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcOriginsResponse> {
        public Builder vpcOriginList(VpcOriginList var1);

        default public Builder vpcOriginList(Consumer<VpcOriginList.Builder> vpcOriginList) {
            return this.vpcOriginList((VpcOriginList)((VpcOriginList.Builder)VpcOriginList.builder().applyMutation(vpcOriginList)).build());
        }
    }
}

