/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionsByResponseHeadersPolicyIdRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, ListDistributionsByResponseHeadersPolicyIdRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDistributionsByResponseHeadersPolicyIdRequest.getter(ListDistributionsByResponseHeadersPolicyIdRequest::marker)).setter(ListDistributionsByResponseHeadersPolicyIdRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListDistributionsByResponseHeadersPolicyIdRequest.getter(ListDistributionsByResponseHeadersPolicyIdRequest::maxItems)).setter(ListDistributionsByResponseHeadersPolicyIdRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<String> RESPONSE_HEADERS_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResponseHeadersPolicyId").getter(ListDistributionsByResponseHeadersPolicyIdRequest.getter(ListDistributionsByResponseHeadersPolicyIdRequest::responseHeadersPolicyId)).setter(ListDistributionsByResponseHeadersPolicyIdRequest.setter(Builder::responseHeadersPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResponseHeadersPolicyId").unmarshallLocationName("ResponseHeadersPolicyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD, RESPONSE_HEADERS_POLICY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Marker", MARKER_FIELD);
            this.put("MaxItems", MAX_ITEMS_FIELD);
            this.put("ResponseHeadersPolicyId", RESPONSE_HEADERS_POLICY_ID_FIELD);
        }
    });
    private final String marker;
    private final String maxItems;
    private final String responseHeadersPolicyId;

    private ListDistributionsByResponseHeadersPolicyIdRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.responseHeadersPolicyId = builder.responseHeadersPolicyId;
    }

    public final String marker() {
        return this.marker;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    public final String responseHeadersPolicyId() {
        return this.responseHeadersPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseHeadersPolicyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByResponseHeadersPolicyIdRequest)) {
            return false;
        }
        ListDistributionsByResponseHeadersPolicyIdRequest other = (ListDistributionsByResponseHeadersPolicyIdRequest)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.responseHeadersPolicyId(), other.responseHeadersPolicyId());
    }

    public final String toString() {
        return ToString.builder((String)"ListDistributionsByResponseHeadersPolicyIdRequest").add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).add("ResponseHeadersPolicyId", (Object)this.responseHeadersPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "ResponseHeadersPolicyId": {
                return Optional.ofNullable(clazz.cast(this.responseHeadersPolicyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByResponseHeadersPolicyIdRequest, T> g) {
        return obj -> g.apply((ListDistributionsByResponseHeadersPolicyIdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String marker;
        private String maxItems;
        private String responseHeadersPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByResponseHeadersPolicyIdRequest model) {
            super(model);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
            this.responseHeadersPolicyId(model.responseHeadersPolicyId);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getResponseHeadersPolicyId() {
            return this.responseHeadersPolicyId;
        }

        public final void setResponseHeadersPolicyId(String responseHeadersPolicyId) {
            this.responseHeadersPolicyId = responseHeadersPolicyId;
        }

        @Override
        public final Builder responseHeadersPolicyId(String responseHeadersPolicyId) {
            this.responseHeadersPolicyId = responseHeadersPolicyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByResponseHeadersPolicyIdRequest build() {
            return new ListDistributionsByResponseHeadersPolicyIdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionsByResponseHeadersPolicyIdRequest> {
        public Builder marker(String var1);

        public Builder maxItems(String var1);

        public Builder responseHeadersPolicyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

