/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionIdList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionsByVpcOriginIdResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListDistributionsByVpcOriginIdResponse> {
    private static final SdkField<DistributionIdList> DISTRIBUTION_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DistributionIdList").getter(ListDistributionsByVpcOriginIdResponse.getter(ListDistributionsByVpcOriginIdResponse::distributionIdList)).setter(ListDistributionsByVpcOriginIdResponse.setter(Builder::distributionIdList)).constructor(DistributionIdList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionIdList").unmarshallLocationName("DistributionIdList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DistributionIdList", DISTRIBUTION_ID_LIST_FIELD);
        }
    });
    private final DistributionIdList distributionIdList;

    private ListDistributionsByVpcOriginIdResponse(BuilderImpl builder) {
        super(builder);
        this.distributionIdList = builder.distributionIdList;
    }

    public final DistributionIdList distributionIdList() {
        return this.distributionIdList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionIdList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByVpcOriginIdResponse)) {
            return false;
        }
        ListDistributionsByVpcOriginIdResponse other = (ListDistributionsByVpcOriginIdResponse)((Object)obj);
        return Objects.equals(this.distributionIdList(), other.distributionIdList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDistributionsByVpcOriginIdResponse").add("DistributionIdList", (Object)this.distributionIdList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionIdList": {
                return Optional.ofNullable(clazz.cast(this.distributionIdList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByVpcOriginIdResponse, T> g) {
        return obj -> g.apply((ListDistributionsByVpcOriginIdResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private DistributionIdList distributionIdList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByVpcOriginIdResponse model) {
            super(model);
            this.distributionIdList(model.distributionIdList);
        }

        public final DistributionIdList.Builder getDistributionIdList() {
            return this.distributionIdList != null ? this.distributionIdList.toBuilder() : null;
        }

        public final void setDistributionIdList(DistributionIdList.BuilderImpl distributionIdList) {
            this.distributionIdList = distributionIdList != null ? distributionIdList.build() : null;
        }

        @Override
        public final Builder distributionIdList(DistributionIdList distributionIdList) {
            this.distributionIdList = distributionIdList;
            return this;
        }

        @Override
        public ListDistributionsByVpcOriginIdResponse build() {
            return new ListDistributionsByVpcOriginIdResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionsByVpcOriginIdResponse> {
        public Builder distributionIdList(DistributionIdList var1);

        default public Builder distributionIdList(Consumer<DistributionIdList.Builder> distributionIdList) {
            return this.distributionIdList((DistributionIdList)((DistributionIdList.Builder)DistributionIdList.builder().applyMutation(distributionIdList)).build());
        }
    }
}

