/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCloudFrontOriginAccessIdentityConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityConfigResponse> {
    private static final SdkField<CloudFrontOriginAccessIdentityConfig> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudFrontOriginAccessIdentityConfig").getter(GetCloudFrontOriginAccessIdentityConfigResponse.getter(GetCloudFrontOriginAccessIdentityConfigResponse::cloudFrontOriginAccessIdentityConfig)).setter(GetCloudFrontOriginAccessIdentityConfigResponse.setter(Builder::cloudFrontOriginAccessIdentityConfig)).constructor(CloudFrontOriginAccessIdentityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontOriginAccessIdentityConfig").unmarshallLocationName("CloudFrontOriginAccessIdentityConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetCloudFrontOriginAccessIdentityConfigResponse.getter(GetCloudFrontOriginAccessIdentityConfigResponse::eTag)).setter(GetCloudFrontOriginAccessIdentityConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CloudFrontOriginAccessIdentityConfig", CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD);
            this.put("ETag", E_TAG_FIELD);
        }
    });
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;
    private final String eTag;

    private GetCloudFrontOriginAccessIdentityConfigResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
        this.eTag = builder.eTag;
    }

    public final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return this.cloudFrontOriginAccessIdentityConfig;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontOriginAccessIdentityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFrontOriginAccessIdentityConfigResponse)) {
            return false;
        }
        GetCloudFrontOriginAccessIdentityConfigResponse other = (GetCloudFrontOriginAccessIdentityConfigResponse)((Object)obj);
        return Objects.equals(this.cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetCloudFrontOriginAccessIdentityConfigResponse").add("CloudFrontOriginAccessIdentityConfig", (Object)this.cloudFrontOriginAccessIdentityConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFrontOriginAccessIdentityConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontOriginAccessIdentityConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCloudFrontOriginAccessIdentityConfigResponse, T> g) {
        return obj -> g.apply((GetCloudFrontOriginAccessIdentityConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFrontOriginAccessIdentityConfigResponse model) {
            super(model);
            this.cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
            this.eTag(model.eTag);
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return this.cloudFrontOriginAccessIdentityConfig != null ? this.cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.build() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetCloudFrontOriginAccessIdentityConfigResponse build() {
            return new GetCloudFrontOriginAccessIdentityConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityConfigResponse> {
        public Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig var1);

        default public Builder cloudFrontOriginAccessIdentityConfig(Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return this.cloudFrontOriginAccessIdentityConfig((CloudFrontOriginAccessIdentityConfig)((CloudFrontOriginAccessIdentityConfig.Builder)CloudFrontOriginAccessIdentityConfig.builder().applyMutation(cloudFrontOriginAccessIdentityConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

