/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.FunctionStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestFunctionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, TestFunctionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TestFunctionRequest.getter(TestFunctionRequest::name)).setter(TestFunctionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(TestFunctionRequest.getter(TestFunctionRequest::ifMatch)).setter(TestFunctionRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(TestFunctionRequest.getter(TestFunctionRequest::stageAsString)).setter(TestFunctionRequest.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").unmarshallLocationName("Stage").build()}).build();
    private static final SdkField<SdkBytes> EVENT_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("EventObject").getter(TestFunctionRequest.getter(TestFunctionRequest::eventObject)).setter(TestFunctionRequest.setter(Builder::eventObject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventObject").unmarshallLocationName("EventObject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IF_MATCH_FIELD, STAGE_FIELD, EVENT_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("If-Match", IF_MATCH_FIELD);
            this.put("Stage", STAGE_FIELD);
            this.put("EventObject", EVENT_OBJECT_FIELD);
        }
    });
    private final String name;
    private final String ifMatch;
    private final String stage;
    private final SdkBytes eventObject;

    private TestFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ifMatch = builder.ifMatch;
        this.stage = builder.stage;
        this.eventObject = builder.eventObject;
    }

    public final String name() {
        return this.name;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final FunctionStage stage() {
        return FunctionStage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final SdkBytes eventObject() {
        return this.eventObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventObject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestFunctionRequest)) {
            return false;
        }
        TestFunctionRequest other = (TestFunctionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.eventObject(), other.eventObject());
    }

    public final String toString() {
        return ToString.builder((String)"TestFunctionRequest").add("Name", (Object)this.name()).add("IfMatch", (Object)this.ifMatch()).add("Stage", (Object)this.stageAsString()).add("EventObject", (Object)(this.eventObject() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "EventObject": {
                return Optional.ofNullable(clazz.cast(this.eventObject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestFunctionRequest, T> g) {
        return obj -> g.apply((TestFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String name;
        private String ifMatch;
        private String stage;
        private SdkBytes eventObject;

        private BuilderImpl() {
        }

        private BuilderImpl(TestFunctionRequest model) {
            super(model);
            this.name(model.name);
            this.ifMatch(model.ifMatch);
            this.stage(model.stage);
            this.eventObject(model.eventObject);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final ByteBuffer getEventObject() {
            return this.eventObject == null ? null : this.eventObject.asByteBuffer();
        }

        public final void setEventObject(ByteBuffer eventObject) {
            this.eventObject(eventObject == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)eventObject));
        }

        @Override
        public final Builder eventObject(SdkBytes eventObject) {
            this.eventObject = eventObject;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestFunctionRequest build() {
            return new TestFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestFunctionRequest> {
        public Builder name(String var1);

        public Builder ifMatch(String var1);

        public Builder stage(String var1);

        public Builder stage(FunctionStage var1);

        public Builder eventObject(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

