/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.KeyValueStoreList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeyValueStoresResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListKeyValueStoresResponse> {
    private static final SdkField<KeyValueStoreList> KEY_VALUE_STORE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyValueStoreList").getter(ListKeyValueStoresResponse.getter(ListKeyValueStoresResponse::keyValueStoreList)).setter(ListKeyValueStoresResponse.setter(Builder::keyValueStoreList)).constructor(KeyValueStoreList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValueStoreList").unmarshallLocationName("KeyValueStoreList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_VALUE_STORE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyValueStoreList", KEY_VALUE_STORE_LIST_FIELD);
        }
    });
    private final KeyValueStoreList keyValueStoreList;

    private ListKeyValueStoresResponse(BuilderImpl builder) {
        super(builder);
        this.keyValueStoreList = builder.keyValueStoreList;
    }

    public final KeyValueStoreList keyValueStoreList() {
        return this.keyValueStoreList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValueStoreList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyValueStoresResponse)) {
            return false;
        }
        ListKeyValueStoresResponse other = (ListKeyValueStoresResponse)((Object)obj);
        return Objects.equals(this.keyValueStoreList(), other.keyValueStoreList());
    }

    public final String toString() {
        return ToString.builder((String)"ListKeyValueStoresResponse").add("KeyValueStoreList", (Object)this.keyValueStoreList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyValueStoreList": {
                return Optional.ofNullable(clazz.cast(this.keyValueStoreList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListKeyValueStoresResponse, T> g) {
        return obj -> g.apply((ListKeyValueStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private KeyValueStoreList keyValueStoreList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyValueStoresResponse model) {
            super(model);
            this.keyValueStoreList(model.keyValueStoreList);
        }

        public final KeyValueStoreList.Builder getKeyValueStoreList() {
            return this.keyValueStoreList != null ? this.keyValueStoreList.toBuilder() : null;
        }

        public final void setKeyValueStoreList(KeyValueStoreList.BuilderImpl keyValueStoreList) {
            this.keyValueStoreList = keyValueStoreList != null ? keyValueStoreList.build() : null;
        }

        @Override
        public final Builder keyValueStoreList(KeyValueStoreList keyValueStoreList) {
            this.keyValueStoreList = keyValueStoreList;
            return this;
        }

        @Override
        public ListKeyValueStoresResponse build() {
            return new ListKeyValueStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKeyValueStoresResponse> {
        public Builder keyValueStoreList(KeyValueStoreList var1);

        default public Builder keyValueStoreList(Consumer<KeyValueStoreList.Builder> keyValueStoreList) {
            return this.keyValueStoreList((KeyValueStoreList)((KeyValueStoreList.Builder)KeyValueStoreList.builder().applyMutation(keyValueStoreList)).build());
        }
    }
}

