/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOriginRequestPolicyResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetOriginRequestPolicyResponse> {
    private static final SdkField<OriginRequestPolicy> ORIGIN_REQUEST_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginRequestPolicy").getter(GetOriginRequestPolicyResponse.getter(GetOriginRequestPolicyResponse::originRequestPolicy)).setter(GetOriginRequestPolicyResponse.setter(Builder::originRequestPolicy)).constructor(OriginRequestPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicy").unmarshallLocationName("OriginRequestPolicy").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetOriginRequestPolicyResponse.getter(GetOriginRequestPolicyResponse::eTag)).setter(GetOriginRequestPolicyResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_REQUEST_POLICY_FIELD, E_TAG_FIELD));
    private final OriginRequestPolicy originRequestPolicy;
    private final String eTag;

    private GetOriginRequestPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.originRequestPolicy = builder.originRequestPolicy;
        this.eTag = builder.eTag;
    }

    public final OriginRequestPolicy originRequestPolicy() {
        return this.originRequestPolicy;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originRequestPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOriginRequestPolicyResponse)) {
            return false;
        }
        GetOriginRequestPolicyResponse other = (GetOriginRequestPolicyResponse)((Object)obj);
        return Objects.equals(this.originRequestPolicy(), other.originRequestPolicy()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetOriginRequestPolicyResponse").add("OriginRequestPolicy", (Object)this.originRequestPolicy()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginRequestPolicy": {
                return Optional.ofNullable(clazz.cast(this.originRequestPolicy()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOriginRequestPolicyResponse, T> g) {
        return obj -> g.apply((GetOriginRequestPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private OriginRequestPolicy originRequestPolicy;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOriginRequestPolicyResponse model) {
            super(model);
            this.originRequestPolicy(model.originRequestPolicy);
            this.eTag(model.eTag);
        }

        public final OriginRequestPolicy.Builder getOriginRequestPolicy() {
            return this.originRequestPolicy != null ? this.originRequestPolicy.toBuilder() : null;
        }

        public final void setOriginRequestPolicy(OriginRequestPolicy.BuilderImpl originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy != null ? originRequestPolicy.build() : null;
        }

        @Override
        public final Builder originRequestPolicy(OriginRequestPolicy originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetOriginRequestPolicyResponse build() {
            return new GetOriginRequestPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOriginRequestPolicyResponse> {
        public Builder originRequestPolicy(OriginRequestPolicy var1);

        default public Builder originRequestPolicy(Consumer<OriginRequestPolicy.Builder> originRequestPolicy) {
            return this.originRequestPolicy((OriginRequestPolicy)((OriginRequestPolicy.Builder)OriginRequestPolicy.builder().applyMutation(originRequestPolicy)).build());
        }

        public Builder eTag(String var1);
    }
}

