/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;

public class ListCloudFrontOriginAccessIdentitiesPublisher
implements SdkPublisher<ListCloudFrontOriginAccessIdentitiesResponse> {
    private final CloudFrontAsyncClient client;
    private final ListCloudFrontOriginAccessIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCloudFrontOriginAccessIdentitiesPublisher(CloudFrontAsyncClient client, ListCloudFrontOriginAccessIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCloudFrontOriginAccessIdentitiesPublisher(CloudFrontAsyncClient client, ListCloudFrontOriginAccessIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCloudFrontOriginAccessIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCloudFrontOriginAccessIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CloudFrontOriginAccessIdentitySummary> items() {
        Function<ListCloudFrontOriginAccessIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudFrontOriginAccessIdentityList() != null && response.cloudFrontOriginAccessIdentityList().items() != null) {
                return response.cloudFrontOriginAccessIdentityList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCloudFrontOriginAccessIdentitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCloudFrontOriginAccessIdentitiesResponseFetcher
    implements AsyncPageFetcher<ListCloudFrontOriginAccessIdentitiesResponse> {
        private ListCloudFrontOriginAccessIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            return previousPage.cloudFrontOriginAccessIdentityList().isTruncated();
        }

        public CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> nextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListCloudFrontOriginAccessIdentitiesPublisher.this.client.listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesPublisher.this.firstRequest);
            }
            return ListCloudFrontOriginAccessIdentitiesPublisher.this.client.listCloudFrontOriginAccessIdentities((ListCloudFrontOriginAccessIdentitiesRequest)((Object)ListCloudFrontOriginAccessIdentitiesPublisher.this.firstRequest.toBuilder().marker(previousPage.cloudFrontOriginAccessIdentityList().nextMarker()).build()));
        }
    }
}

