/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary;

public class ListStreamingDistributionsPublisher
implements SdkPublisher<ListStreamingDistributionsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListStreamingDistributionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamingDistributionsPublisher(CloudFrontAsyncClient client, ListStreamingDistributionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamingDistributionsPublisher(CloudFrontAsyncClient client, ListStreamingDistributionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamingDistributionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamingDistributionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamingDistributionSummary> items() {
        Function<ListStreamingDistributionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingDistributionList() != null && response.streamingDistributionList().items() != null) {
                return response.streamingDistributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamingDistributionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamingDistributionsResponseFetcher
    implements AsyncPageFetcher<ListStreamingDistributionsResponse> {
        private ListStreamingDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingDistributionsResponse previousPage) {
            return previousPage.streamingDistributionList().isTruncated();
        }

        public CompletableFuture<ListStreamingDistributionsResponse> nextPage(ListStreamingDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingDistributionsPublisher.this.client.listStreamingDistributions(ListStreamingDistributionsPublisher.this.firstRequest);
            }
            return ListStreamingDistributionsPublisher.this.client.listStreamingDistributions((ListStreamingDistributionsRequest)((Object)ListStreamingDistributionsPublisher.this.firstRequest.toBuilder().marker(previousPage.streamingDistributionList().nextMarker()).build()));
        }
    }
}

