/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name of an HTTP header that CloudFront removes from HTTP responses to requests that match the cache behavior that
 * this response headers policy is attached to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicyRemoveHeader implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicyRemoveHeader.Builder, ResponseHeadersPolicyRemoveHeader> {
    private static final SdkField<String> HEADER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Header")
            .getter(getter(ResponseHeadersPolicyRemoveHeader::header))
            .setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header")
                    .unmarshallLocationName("Header").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String header;

    private ResponseHeadersPolicyRemoveHeader(BuilderImpl builder) {
        this.header = builder.header;
    }

    /**
     * <p>
     * The HTTP header name.
     * </p>
     * 
     * @return The HTTP header name.
     */
    public final String header() {
        return header;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyRemoveHeader)) {
            return false;
        }
        ResponseHeadersPolicyRemoveHeader other = (ResponseHeadersPolicyRemoveHeader) obj;
        return Objects.equals(header(), other.header());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicyRemoveHeader").add("Header", header()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyRemoveHeader, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyRemoveHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicyRemoveHeader> {
        /**
         * <p>
         * The HTTP header name.
         * </p>
         * 
         * @param header
         *        The HTTP header name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(String header);
    }

    static final class BuilderImpl implements Builder {
        private String header;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyRemoveHeader model) {
            header(model.header);
        }

        public final String getHeader() {
            return header;
        }

        public final void setHeader(String header) {
            this.header = header;
        }

        @Override
        public final Builder header(String header) {
            this.header = header;
            return this;
        }

        @Override
        public ResponseHeadersPolicyRemoveHeader build() {
            return new ResponseHeadersPolicyRemoveHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
